<?php
$thumb_size = 'rdtheme-size1';

$rdtheme_has_entry_meta  = ( ( !has_post_thumbnail() && RDTheme::$options['blog_date'] ) || RDTheme::$options['blog_author_name'] || RDTheme::$options['blog_comment_num'] || RDTheme::$options['blog_cats'] ) ? true : false;
$rdtheme_time_html       = sprintf( '%s<span>%s</span>', get_the_time( 'd' ), get_the_time( 'M, Y' ) );
$rdtheme_time_html       = apply_filters( 'rdtheme_single_time', $rdtheme_time_html );
$rdtheme_time_html_2     = apply_filters( 'rdtheme_single_time_no_thumb', get_the_time( 'd M, Y' ) );

$rdtheme_comments_number = number_format_i18n( get_comments_number() );
$rdtheme_comments_html = $rdtheme_comments_number < 2 ? __( 'Comment' , 'seoengine' ) : __( 'Comments' , 'seoengine' );
$rdtheme_comments_html = $rdtheme_comments_number . ' ' . $rdtheme_comments_html;
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'post-each' ); ?>>
	<div class="entry-header">
		<?php if ( has_post_thumbnail() ): ?>
			<a class="entry-thumbnail-area" href="<?php the_permalink();?>">
				<div class="entry-thumbnail"><?php the_post_thumbnail( $thumb_size );?></div>
				<?php if ( RDTheme::$options['blog_date'] ): ?>
					<div class="date"><?php echo wp_kses_post( $rdtheme_time_html );?></div>
				<?php endif; ?>
			</a>
		<?php endif; ?>
		<div class="entry-title"><h2><a href="<?php the_permalink();?>"><?php the_title();?></a></h2></div>
		<?php if ( $rdtheme_has_entry_meta ): ?>
			<div class="entry-meta">
				<ul>
					<?php if ( !has_post_thumbnail() && RDTheme::$options['blog_date'] ): ?>
						<li><?php _e( '<span>Posted on</span>', 'seoengine' ); echo wp_kses_post( $rdtheme_time_html_2 );?></li>
					<?php endif; ?>
					<?php if ( RDTheme::$options['blog_author_name'] ): ?>
						<li><?php _e( '<span>Posted by</span>', 'seoengine' ) . the_author_posts_link();?></li>
					<?php endif; ?>
					<?php if ( RDTheme::$options['blog_comment_num'] ): ?>
						<li><?php echo esc_html( $rdtheme_comments_html );?></li>
					<?php endif; ?>
					<?php if ( RDTheme::$options['blog_cats'] ): ?>
						<li><?php _e( '<span>Categories:</span>', 'seoengine' ). the_category( ', ' );?></li>
					<?php endif; ?>
				</ul>			
			</div>			
		<?php endif; ?>
	</div>
	<div class="entry-content">
		<?php the_excerpt();?>
	</div>
</article>
