<?php
$rdtheme_has_entry_meta  = ( ( !has_post_thumbnail() && RDTheme::$options['post_date'] ) || RDTheme::$options['post_author_name'] || RDTheme::$options['post_comment_num'] || RDTheme::$options['post_cats'] ) ? true : false;
$rdtheme_comments_number = get_comments_number();
$rdtheme_time_html       = sprintf( '%s<span>%s</span>', get_the_time( 'd' ), get_the_time( 'M, Y' ) );
$rdtheme_time_html       = apply_filters( 'rdtheme_single_time', $rdtheme_time_html );
$rdtheme_time_html_2     = apply_filters( 'rdtheme_single_time_no_thumb', get_the_time( 'd M, Y' ) );
$rdtheme_author_id       = get_the_author_meta( 'ID' );
$rdtheme_author_bio      = get_the_author_meta( 'description' );
$rdtheme_footer_col      = ( RDTheme::$options['post_tags'] && has_tag() && RDTheme::$options['post_social'] ) ? 'col-sm-6 col-xs-12' : 'col-sm-12 col-xs-12';
?>
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="entry-header">
		<?php if ( has_post_thumbnail() ): ?>
			<div class="entry-thumbnail-area">
				<div class="entry-thumbnail"><?php the_post_thumbnail( 'rdtheme-size1' );?></div>
				<?php if ( RDTheme::$options['post_date'] ): ?>
					<div class="date"><?php echo wp_kses_post( $rdtheme_time_html );?></div>
				<?php endif; ?>
			</div>
		<?php endif; ?>
		<?php if ( $rdtheme_has_entry_meta ): ?>
			<div class="entry-meta">
				<ul>
					<?php if ( !has_post_thumbnail() && RDTheme::$options['post_date'] ): ?>
						<li><?php _e( '<span>Posted on</span>', 'seoengine' ); echo wp_kses_post( $rdtheme_time_html_2 );?></li>
					<?php endif; ?>
					<?php if ( RDTheme::$options['post_author_name'] ): ?>
						<li><?php _e( '<span>Posted by</span>', 'seoengine' ) . the_author_posts_link();?></li>
					<?php endif; ?>
					<?php if ( RDTheme::$options['post_comment_num'] ): ?>
						<li><?php printf( _nx( '%s Comment', '%s Comments', $rdtheme_comments_number, 'comments number', 'seoengine' ), number_format_i18n( $rdtheme_comments_number ) );?></li>
					<?php endif; ?>
					<?php if ( RDTheme::$options['post_cats'] && has_category() ): ?>
						<li><?php _e( '<span>Categories:</span>', 'seoengine' ). the_category( ', ' );?></li>
					<?php endif; ?>
				</ul>			
			</div>			
		<?php endif; ?>
	</div>
	<div class="entry-content">
		<?php the_content();?>
		<?php wp_link_pages();?>
	</div>
	<?php if ( RDTheme::$options['post_tags'] || ( function_exists( 'ADDTOANY_SHARE_SAVE_KIT' ) && RDTheme::$options['post_social'] ) ): ?>
		<div class="entry-footer">
			<div class="entry-footer-meta">
				<div class="row">
					<?php if ( RDTheme::$options['post_tags'] && has_tag() ): ?>
						<div class="<?php echo esc_attr( $rdtheme_footer_col );?>">
							<div class="tags"><?php _e( '<span>Tags:</span>', 'seoengine' );?><?php echo get_the_term_list( $post->ID, 'post_tag', '', ', ' ); ?></div>
						</div>
					<?php endif; ?>
					<?php if ( RDTheme::$options['post_social'] ): ?>
						<div class="<?php echo esc_attr( $rdtheme_footer_col );?>">
							<div class="share">
								<?php 
								if ( function_exists( 'ADDTOANY_SHARE_SAVE_KIT' ) ) {
									ADDTOANY_SHARE_SAVE_KIT();
								}
								else {
									get_template_part( 'template-parts/social' );
								}
								?>
							</div>
						</div>					
					<?php endif; ?>
				</div>				
			</div>
		</div>	
	<?php endif; ?>
	<?php if ( RDTheme::$options['post_author_bio'] && $rdtheme_author_bio ): ?>
		<div class="about-author">
			<div class="pull-left">
				<?php echo get_avatar( $rdtheme_author_id, 120 ); ?>
			</div>
			<div class="media-body">
				<div class="author-title"><?php _e( 'About The Author', 'seoengine' );?></div>
				<div class="author-name"><?php the_author_posts_link();?></div>
				<div class="author-bio"><?php echo esc_html( $rdtheme_author_bio );?></div>
			</div>
			<div class="clear"></div>
		</div>			
	<?php endif; ?>
</div>