<?php
global $post;
$seo_designation = get_post_meta( $post->ID, 'seo_team_designation', true );
$seo_socials     = get_post_meta( $post->ID, 'seo_team_socials', true );
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="row">
		<div class="col-md-4 col-sm-5 col-xs-12">
			<div class="team-detail-image">
				<?php the_post_thumbnail( 'rdtheme-size3' );?>
			</div>
		</div>
		<div class="col-md-8 col-sm-7 col-xs-12">
			<div class="team-detail-content">
				<div class="team-detail-heading">
					<h2><?php the_title();?></h2>
					<?php if ( $seo_designation ): ?>
						<div class="team-designation"><?php echo esc_html( $seo_designation );?></div>
					<?php endif; ?>
					<?php if ( !empty( $seo_socials ) ): ?>
						<ul class="team-social">
							<?php foreach ( $seo_socials as $seo_key => $seo_social ): ?>
								<?php if ( !empty( $seo_social ) ): ?>
									<li><a target="_blank" style="color:<?php echo esc_attr( RDTheme::$team_social_fields[$seo_key]['color'] );?>;" href="<?php echo esc_attr( $seo_social );?>"><i class="fa <?php echo esc_attr( RDTheme::$team_social_fields[$seo_key]['icon'] );?>"></i></a></li>
								<?php endif; ?>
							<?php endforeach; ?>
						</ul>						
					<?php endif; ?>
				</div>
				<?php the_content();?>
			</div>
		</div>
	</div>
</article>