<?php
$rdtheme_thumb_size = 'rdtheme-size1';

global $post;
$rdtheme_fields = get_post_meta( $post->ID, 'seo_portfolio_fields', true );
$rdtheme_cats   = wp_get_post_terms( $post->ID, 'seo_portfolio_category', array( "fields" => "names" ) );
$rdtheme_cats   = implode( ', ', $rdtheme_cats );
?>
<div id="post-<?php the_ID();?>" <?php post_class( 'rdtheme-portfolio' );?>>
	<div class="row">
		<?php if ( has_post_thumbnail ( ) ):?>
			<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
				<?php if ( has_post_thumbnail() ): ?>
					<div class="rt-portfolio-thumbnail"><?php the_post_thumbnail( $rdtheme_thumb_size );?></div>
				<?php endif; ?>
			</div>
		<?php endif;?> 
		<div class="col-md-8 col-sm-7 col-xs-12">
			<div class="rt-portfolio-detail"><?php the_content();?></div>
		</div>
		<div class="col-md-4 col-sm-5 col-xs-12">
			<ul class="rt-portfolio-info">
				<?php foreach ( $rdtheme_fields as $rdtheme_field ):?>
					<?php if ( isset( $rdtheme_field['portfolio_label'] ) && isset( $rdtheme_field['portfolio_value'] ) ): ?>
						<li><span class="rt-portfolio-label"><?php echo esc_html( $rdtheme_field['portfolio_label'] );?>:</span> <span class="rt-portfolio-value"><?php echo wp_kses_post( $rdtheme_field['portfolio_value'] );?></span></li>
					<?php endif; ?>
				<?php endforeach;?>
				<?php if ( has_term( '', 'seo_portfolio_category' ) ): ?>
					<li class="rt-portfolio-cats"><span class="rt-portfolio-label"><?php _e( 'Categories', 'seoengine' );?>:</span> <span class="rt-portfolio-value"><?php echo wp_kses_post( $rdtheme_cats );?></span></li>
				<?php endif; ?>
			</ul>
		</div>							
	</div>
</div>