<?php
$rdtheme_owl_data = array( 
	'nav'                => false,
	'dots'               => false,
	'autoplay'           => true,
	'autoplayTimeout'    => 5000,
	'autoplaySpeed'      => 200,
	'autoplayHoverPause' => true,
	'loop'               => true,
	'margin'             => 30,
	'responsiveBaseElement'  => '.related-cases .owl-carousel',
	'responsive'         => array(
		'0'    => array( 'items' => 1 ),
		'340'  => array( 'items' => 2 ),
		'570'  => array( 'items' => 3 ),
		'940'  => array( 'items' => 4 ),
	)
);
$rdtheme_owl_data = json_encode( $rdtheme_owl_data );

$rdtheme_thumb_size = 'rdtheme-size2';
$rdtheme_id = get_the_id();
$rdtheme_related_active = get_post_meta( $rdtheme_id, 'seoengine_rcase_display', 'true' );
$rdtheme_related = get_post_meta( $rdtheme_id, 'seoengine_rcases', 'true' );
$rdtheme_related = !empty( $rdtheme_related ) ? $rdtheme_related : array();

$rdtheme_args = array(
	'post_type'           => 'seo_case',
	'post__in'            => $rdtheme_related,
	'posts_per_page'      =>-1,
	'ignore_sticky_posts' => true,
);
$rdtheme_query = new WP_Query( $rdtheme_args );
?>
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php if ( has_post_thumbnail() ): ?>
		<div class="entry-thumbnail"><?php the_post_thumbnail( 'rdtheme-size1' );?></div>
	<?php endif; ?>
	<div class="entry-content">
		<?php the_content();?>
	</div>
	<?php if ( $rdtheme_related_active=='enabled' && $rdtheme_query->have_posts() ) :?>
		<?php
		wp_enqueue_style( 'owl-carousel' );
		wp_enqueue_style( 'owl-theme-default' );
		wp_enqueue_script( 'owl-carousel' );
		?>
		<div class="related-cases mt80 mb50">
			<div class="owl-wrap rt-owl-nav-3">
				<div class="section-title">
					<h2 class="owl-custom-nav-title"><?php _e( 'Related Case Studies' , 'seoengine' );?></h2>
					<div class="owl-custom-nav">
						<div class="owl-prev"><i class="fa fa-angle-left"></i></div><div class="owl-next"><i class="fa fa-angle-right"></i></div>
					</div>
					<div class="clear"></div>
				</div>
				<div class="owl-theme owl-carousel rt-owl-carousel" data-carousel-options="<?php echo esc_attr( $rdtheme_owl_data );?>">

					<?php while ( $rdtheme_query->have_posts() ) : $rdtheme_query->the_post();?>
						<?php
						$content = get_the_content();
						$content = apply_filters( 'the_content', $content );
						$content = wp_trim_words( $content, 10 );
						$thumb_class = has_post_thumbnail() ? '':' vc-nothumb';
						?>
						<div class="single-item<?php echo esc_attr( $thumb_class );?>">
							<div class="single-item-meta">
								<a class="single-item-image" href="<?php the_permalink();?>"><?php the_post_thumbnail( $rdtheme_thumb_size );?></a>
							</div>
							<div class="single-item-content">
								<h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
								<div><?php echo wp_kses_post( $content );?></div>
							</div>
						</div>
					<?php endwhile;?>
				</div>
			</div>	
		</div>
	<?php endif;?>
	<?php wp_reset_query();?>
</div>