<?php
$thumb_size = 'rdtheme-size2';

add_filter( 'excerpt_length', array( 'RDTheme_Helper', 'small_excerpt' ), 15 );

$rdtheme_has_entry_meta  = ( ( !has_post_thumbnail() && RDTheme::$options['blog_date'] ) || RDTheme::$options['blog_author_name'] || RDTheme::$options['blog_comment_num'] || RDTheme::$options['blog_cats'] ) ? true : false;
$rdtheme_time_html     = apply_filters( 'rdtheme_single_time_no_thumb', get_the_time( 'd M, Y' ) );

$rdtheme_comments_number = number_format_i18n( get_comments_number() );
$rdtheme_comments_html = $rdtheme_comments_number < 2 ? __( 'Comment' , 'seoengine' ) : __( 'Comments' , 'seoengine' );
$rdtheme_comments_html = $rdtheme_comments_number . ' ' . $rdtheme_comments_html;
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'post-each' ); ?>>
	<a class="post-left" href="<?php the_permalink();?>">
		<?php
		if ( has_post_thumbnail() ){
			the_post_thumbnail( $thumb_size );
		}
		else {
			if ( !empty( RDTheme::$options['no_preview_image']['id'] ) ) {
				echo wp_get_attachment_image( RDTheme::$options['no_preview_image']['id'], $thumb_size );
			}
			else {
				echo '<img class="attachment-rdtheme-size2 size-rdtheme-size2 wp-post-image" src="'.RDTHEME_IMG_URL.'noimage_336_290.jpg" alt="'.get_the_title().'">';
			}
		}
		?>
	</a>
	<div class="post-right">
		<div class="entry-header">
			<?php if ( RDTheme::$options['blog_date'] ): ?>
				<div class="entry-date"><?php echo wp_kses_post( $rdtheme_time_html );?></div>
			<?php endif; ?>
			<div class="entry-title"><h2><a href="<?php the_permalink();?>"><?php the_title();?></a></h2></div>
			<?php if ( $rdtheme_has_entry_meta ): ?>
				<div class="entry-meta">
					<ul>
						<?php if ( RDTheme::$options['blog_author_name'] ): ?>
							<li><?php _e( '<span>Posted by</span>', 'seoengine' ) . the_author_posts_link();?></li>
						<?php endif; ?>
						<?php if ( RDTheme::$options['blog_comment_num'] ): ?>
							<li><?php echo esc_html( $rdtheme_comments_html );?></li>
						<?php endif; ?>
					</ul>			
				</div>			
			<?php endif; ?>
		</div>
		<div class="entry-content">
			<?php the_excerpt();?>
			<a class="readmore-btn" href="<?php the_permalink(); ?>"><?php _e( 'Read More', 'seoengine' );?></a>
		</div>
	</div>
	<div class="clear"></div>
</article>