<?php
/*-------------------------------------
INDEX
=======================================
#. Buttons
#. Top Bar
#. Header
#. Banner
#. Footer
#. Widgets
#. Page Options
#. Inner Contents
#. Error 404
#. WooCommerce
#. Plugin: Contact Form 7
-------------------------------------*/

$primary_color         = RDTheme::$options['primary_color']; // #26c6da
$secondery_color       = RDTheme::$options['secondery_color']; // #19abbd
$primary_rgb           = RDTheme_Helper::hex2rgb( $primary_color ); // 38, 198, 218

$menu_typo             = RDTheme::$options['menu_typo'];
$menu_color            = RDTheme::$options['menu_color'];
$menu_color_tr         = RDTheme::$options['menu_color_tr'];
$menu_hover_color      = RDTheme::$options['menu_hover_color'];
$submenu_typo          = RDTheme::$options['submenu_typo'];
$submenu_color         = RDTheme::$options['submenu_color'];
$submenu_bgcolor       = RDTheme::$options['submenu_bgcolor'];
$submenu_hover_color   = RDTheme::$options['submenu_hover_color'];
$submenu_hover_bgcolor = RDTheme::$options['submenu_hover_bgcolor'];
$resmenu_typo          = RDTheme::$options['resmenu_typo'];

$rdtheme_typo_body     = RDTheme::$options['typo_body'];
$rdtheme_typo_h1       = RDTheme::$options['typo_h1'];
$rdtheme_typo_h2       = RDTheme::$options['typo_h2'];
$rdtheme_typo_h3       = RDTheme::$options['typo_h3'];
$rdtheme_typo_h4       = RDTheme::$options['typo_h4'];
$rdtheme_typo_h5       = RDTheme::$options['typo_h5'];
$rdtheme_typo_h6       = RDTheme::$options['typo_h6'];
?>

<?php
/*-------------------------------------
#. Buttons
---------------------------------------*/
?>
.rdtheme-button-1,
.rdtheme-button-4 {
	border-color: <?php echo esc_html( $primary_color ); ?>;
}
.rdtheme-button-2 {
	background-color: <?php echo esc_html( $primary_color ); ?>;
}
.rdtheme-button-3:hover {
	color: <?php echo esc_html( $primary_color ); ?> !important;
}
.rdtheme-button-1:hover,
.rdtheme-button-2:hover,
.rdtheme-button-4:hover {
	background-color: <?php echo esc_html( $secondery_color ); ?>;
}

<?php
/*-------------------------------------
#. Logo
---------------------------------------*/
?>
<?php if ( !RDTheme::$options['logo_fixed_height'] ): ?>
.site-header .site-branding a img,
.header-style-3 .site-header .site-branding a img {
	max-height: inherit;
}
<?php endif; ?>
<?php if ( !RDTheme::$options['logo_fixed_height_sticky'] ): ?>
.stick .site-header .site-branding a img {
	max-height: inherit;
}
@media all and (max-width: 767px) {
	.stick .site-header .site-branding a img {
		max-height: 40px;
	}
}
<?php endif; ?>


<?php
/*-------------------------------------
#. Top Bar
---------------------------------------*/
?>
#tophead .tophead-contact .fa,
#tophead .tophead-address .fa,
#tophead .tophead-social li a:hover {
	color: <?php echo esc_html( $primary_color ); ?>;
}
#tophead {
    background-color: <?php echo esc_html( RDTheme::$options['top_bar_bgcolor'] ); ?>;
}
#tophead,
#tophead a,
#tophead .tophead-social li a {
    color: <?php echo esc_html( RDTheme::$options['top_bar_color'] ); ?>;
}
.trheader #tophead,
.trheader #tophead a,
.trheader #tophead .tophead-social li a {
	color: <?php echo esc_html( RDTheme::$options['top_bar_color_tr'] ); ?>;
}

<?php
/*-------------------------------------
#. Header
---------------------------------------*/
?>
<?php // Main Menu ?>
.site-header .main-navigation ul li a {
	font-family: <?php echo esc_html( $menu_typo['font-family'] ); ?>, sans-serif;
	font-size : <?php echo esc_html( $menu_typo['font-size'] ); ?>;
	font-weight : <?php echo esc_html( $menu_typo['font-weight'] ); ?>;
	line-height : <?php echo esc_html( $menu_typo['line-height'] ); ?>;
	color: <?php echo esc_html( $menu_color ); ?>;
	font-style: <?php echo empty( $menu_typo['font-style'] ) ? 'normal' : $menu_typo['font-style']; ?>;
}
.site-header .main-navigation ul.menu > li > a:hover,
.site-header .main-navigation ul.menu > li.current-menu-item > a,
.site-header .main-navigation ul.menu > li.current > a,
.trheader.non-stick .site-header .main-navigation ul.menu > li > a:hover,
.trheader.non-stick .site-header .main-navigation ul.menu > li.current-menu-item > a,
.trheader.non-stick .site-header .main-navigation ul.menu > li.current > a {
	color: <?php echo esc_html( $menu_hover_color ); ?>;
}
.site-header .main-navigation ul li a.active {
	color: <?php echo esc_html( $menu_hover_color );?> !important;
}
.trheader.non-stick .site-header .main-navigation ul.menu > li > a,
.trheader.non-stick .site-header .search-box .search-button i,
.trheader.non-stick .header-icon-seperator,
.trheader.non-stick .header-icon-area .cart-icon-area > a, 
.trheader.non-stick .additional-menu-area a.side-menu-trigger {
	color: <?php echo esc_html( $menu_color_tr ); ?>;
}

<?php // Submenu ?>
.site-header .main-navigation ul li ul li {
	background-color: <?php echo esc_html( $submenu_bgcolor ); ?>;
}
.site-header .main-navigation ul li ul li:hover {
	background-color: <?php echo esc_html( $submenu_hover_bgcolor ); ?>;
}
.site-header .main-navigation ul li ul li a {
	font-family: <?php echo esc_html( $submenu_typo['font-family'] ); ?>, sans-serif;
	font-size : <?php echo esc_html( $submenu_typo['font-size'] ); ?>;
	font-weight : <?php echo esc_html( $submenu_typo['font-weight'] ); ?>;
	line-height : <?php echo esc_html( $submenu_typo['line-height'] ); ?>;
	color: <?php echo esc_html( $submenu_color ); ?>;
	font-style: <?php echo empty( $submenu_typo['font-style'] ) ? 'normal' : $submenu_typo['font-style']; ?>;
}
.site-header .main-navigation ul li ul li:hover > a {
	color: <?php echo esc_html( $submenu_hover_color ); ?>;
}

<?php // Sticky Menu ?>
.stick .site-header {
	border-color: <?php echo esc_html( $primary_color ); ?>
}

<?php // Multi Column Menu ?>
.site-header .main-navigation ul li.mega-menu > ul.sub-menu {
	background-color: <?php echo esc_html( $submenu_bgcolor ); ?>
}
.site-header .main-navigation ul li.mega-menu ul.sub-menu li a {
	color: <?php echo esc_html( $submenu_color ); ?>
}
.site-header .main-navigation ul li.mega-menu ul.sub-menu li a:hover {
	background-color: <?php echo esc_html( $submenu_hover_bgcolor ); ?>;
	color: <?php echo esc_html( $submenu_hover_color ); ?>;
}

<?php // Mean Menu ?>
.mean-container a.meanmenu-reveal,
.mean-container .mean-nav ul li a.mean-expand {
	color: <?php echo esc_html( $menu_hover_color ); ?>;
}
.mean-container a.meanmenu-reveal span {
	background-color: <?php echo esc_html( $menu_hover_color ); ?>;
}
.mean-container .mean-bar {
	border-color: <?php echo esc_html( $menu_hover_color ); ?>;
}
.mean-container .mean-nav ul li a {
	font-family: <?php echo esc_html( $resmenu_typo['font-family'] ); ?>, sans-serif;
	font-size : <?php echo esc_html( $resmenu_typo['font-size'] ); ?>;
	font-weight : <?php echo esc_html( $resmenu_typo['font-weight'] ); ?>;
	line-height : <?php echo esc_html( $resmenu_typo['line-height'] ); ?>;
	color: <?php echo esc_html( $menu_color ); ?>;
	font-style: <?php echo empty( $resmenu_typo['font-style'] ) ? 'normal' : $resmenu_typo['font-style']; ?>;
}
.mean-container .mean-nav ul li a:hover,
.mean-container .mean-nav > ul > li.current-menu-item > a {
	color: <?php echo esc_html( $menu_hover_color ); ?>;
}

<?php // Header icons ?>
.header-icon-area .cart-icon-area .cart-icon-num {
	background-color: <?php echo esc_html( $menu_hover_color );?>;
}
.additional-menu-area a.side-menu-trigger:hover,
.trheader.non-stick .additional-menu-area a.side-menu-trigger:hover {
	color: <?php echo esc_html( $menu_hover_color );?>;
}
.site-header .search-box .search-text {
	border-color: <?php echo esc_html( $menu_hover_color );?>;
}

<?php // Header Layout 3 ?>
.header-style-3 .header-contact .fa,
.header-style-3 .header-social li a:hover,
.header-style-3.trheader .header-social li a:hover {
	color: <?php echo esc_html( $menu_hover_color );?>;
}
.header-style-3.trheader .header-contact li a,
.header-style-3.trheader .header-social li a {
	color: <?php echo esc_html( $menu_color_tr ); ?>;
}

<?php // Header Layout 4 ?>
.header-style-4 .header-contact .fa,
.header-style-4 .header-social li a:hover,
.header-style-4.trheader .header-social li a:hover {
	color: <?php echo esc_html( $menu_hover_color );?>;
}
.header-style-4.trheader .header-contact li a,
.header-style-4.trheader .header-social li a {
	color: <?php echo esc_html( $menu_color_tr ); ?>;
}

<?php // Header Layout 5 ?>
.header-style-5 .header-menu-btn {
	background-color: <?php echo esc_html( $primary_color );?>;
}
.trheader.non-stick.header-style-5 .header-menu-btn {
	color: <?php echo esc_html( $menu_color_tr ); ?>;
}

<?php
/*-------------------------------------
#. Banner
---------------------------------------*/
?>
.entry-banner {
<?php if ( RDTheme::$bgtype == 'bgcolor' ): ?>
	background-color: <?php echo esc_html( RDTheme::$bgcolor );?>;
<?php else: ?>
	background: url(<?php echo esc_url( RDTheme::$bgimg );?>) no-repeat scroll center center / cover;
<?php endif; ?>
}
.entry-banner .entry-banner-content h1 {
	color: <?php echo esc_html( RDTheme::$options['banner_heading_color'] );?>;
}
.breadcrumb-area .entry-breadcrumb span a {
	color: <?php echo esc_html( RDTheme::$options['breadcrumb_link_color'] );?>;
}
.breadcrumb-area .entry-breadcrumb span a:hover {
	color: <?php echo esc_html( RDTheme::$options['breadcrumb_link_hover_color'] );?>;
}
.breadcrumb-area .entry-breadcrumb .breadcrumb-seperator {
	color: <?php echo esc_html( RDTheme::$options['breadcrumb_seperator_color'] );?>;
}
.breadcrumb-area .entry-breadcrumb > span:last-child {
	color: <?php echo esc_html( RDTheme::$options['breadcrumb_active_color'] );?>;
}

<?php
/*-------------------------------------
#. Footer
---------------------------------------*/
?>
.footer-top-area {
	background-color: <?php echo esc_html( RDTheme::$options['footer_bgcolor'] ); ?>;
}
.footer-top-area .widget h3 {
	color: <?php echo esc_html( RDTheme::$options['footer_title_color'] ); ?>;
}
.footer-top-area .widget {
	color: <?php echo esc_html( RDTheme::$options['footer_color'] ); ?>;
}
.footer-top-area .widget ul li a {
	color: <?php echo esc_html( RDTheme::$options['footer_link_color'] ); ?>;
}
.footer-top-area .widget ul li a:hover {
	color: <?php echo esc_html( RDTheme::$options['footer_link_hover_color'] ); ?>;
}
.footer-bottom-area {
	background-color: <?php echo esc_html( RDTheme::$options['copyright_bgcolor'] ); ?>;
}
.footer-bottom-area .footer-bottom-left {
	color: <?php echo esc_html( RDTheme::$options['copyright_color'] ); ?>;
}
.scrollToTop {
	background-color: <?php echo esc_html( $primary_color ); ?>;
}

<?php
/*-------------------------------------
#. Widgets
---------------------------------------*/
?>
.sidebar-widget-area ul li a:hover,
.sidebar-widget-area .widget ul li::before,
.footer-bottom-right li a:hover,
.footer-top-area .widget ul li a:hover,
.search-form .custom-search-input button.btn,
.footer-top-area .widget_recent_entries .post-date {
	color: <?php echo esc_html( $primary_color );?>;
}

.footer-bottom-right li a,
.widget .tagcloud a:hover,
.sidebar-widget-area .widget h3:after {
	background-color: <?php echo esc_html( $primary_color );?>;
}

.footer-bottom-right li a,
.footer-bottom-right li a:hover,
.widget .tagcloud a:hover {
	border-color: <?php echo esc_html( $primary_color );?>;
}

.search-form .custom-search-input button.btn:hover {
	color: <?php echo esc_html( $secondery_color );?>;
}

<?php
/*-------------------------------------
#. Typography
---------------------------------------*/
?>
body {
	font-family: <?php echo esc_html( $rdtheme_typo_body['font-family'] ); ?>, sans-serif;;
	font-size: <?php echo esc_html( $rdtheme_typo_body['font-size'] ); ?>;
	line-height: <?php echo esc_html( $rdtheme_typo_body['line-height'] ); ?>;
	font-weight : <?php echo esc_html( $rdtheme_typo_body['font-weight'] ); ?>;
	font-style: <?php echo empty( $rdtheme_typo_body['font-style'] ) ? 'normal' : $rdtheme_typo_body['font-style']; ?>;
}
h1 {
	font-family: <?php echo esc_html( $rdtheme_typo_h1['font-family'] ); ?>;
	font-size: <?php echo esc_html( $rdtheme_typo_h1['font-size'] ); ?>;
	line-height: <?php echo esc_html( $rdtheme_typo_h1['line-height'] ); ?>;
	font-weight : <?php echo esc_html( $rdtheme_typo_h1['font-weight'] ); ?>;
	font-style: <?php echo empty( $rdtheme_typo_h1['font-style'] ) ? 'normal' : $rdtheme_typo_h1['font-style']; ?>;
}
h2 {
	font-family: <?php echo esc_html( $rdtheme_typo_h2['font-family'] ); ?>, sans-serif;;
	font-size: <?php echo esc_html( $rdtheme_typo_h2['font-size'] ); ?>;
	line-height: <?php echo esc_html( $rdtheme_typo_h2['line-height'] ); ?>;
	font-weight : <?php echo esc_html( $rdtheme_typo_h2['font-weight'] ); ?>;
	font-style: <?php echo empty( $rdtheme_typo_h2['font-style'] ) ? 'normal' : $rdtheme_typo_h2['font-style']; ?>;
}
h3 {
	font-family: <?php echo esc_html( $rdtheme_typo_h3['font-family'] ); ?>, sans-serif;;
	font-size: <?php echo esc_html( $rdtheme_typo_h3['font-size'] ); ?>;
	line-height: <?php echo esc_html( $rdtheme_typo_h3['line-height'] ); ?>;
	font-weight : <?php echo esc_html( $rdtheme_typo_h3['font-weight'] ); ?>;
	font-style: <?php echo empty( $rdtheme_typo_h3['font-style'] ) ? 'normal' : $rdtheme_typo_h3['font-style']; ?>;
}
h4 {
	font-family: <?php echo esc_html( $rdtheme_typo_h4['font-family'] ); ?>, sans-serif;;
	font-size: <?php echo esc_html( $rdtheme_typo_h4['font-size'] ); ?>;
	line-height: <?php echo esc_html( $rdtheme_typo_h4['line-height'] ); ?>;
	font-weight : <?php echo esc_html( $rdtheme_typo_h4['font-weight'] ); ?>;
	font-style: <?php echo empty( $rdtheme_typo_h4['font-style'] ) ? 'normal' : $rdtheme_typo_h4['font-style']; ?>;
}
h5 {
	font-family: <?php echo esc_html( $rdtheme_typo_h5['font-family'] ); ?>, sans-serif;;
	font-size: <?php echo esc_html( $rdtheme_typo_h5['font-size'] ); ?>;
	line-height: <?php echo esc_html( $rdtheme_typo_h5['line-height'] ); ?>;
	font-weight : <?php echo esc_html( $rdtheme_typo_h5['font-weight'] ); ?>;
	font-style: <?php echo empty( $rdtheme_typo_h5['font-style'] ) ? 'normal' : $rdtheme_typo_h5['font-style']; ?>;
}
h6 {
	font-family: <?php echo esc_html( $rdtheme_typo_h6['font-family'] ); ?>, sans-serif;;
	font-size: <?php echo esc_html( $rdtheme_typo_h6['font-size'] ); ?>;
	line-height: <?php echo esc_html( $rdtheme_typo_h6['line-height'] ); ?>;
	font-weight : <?php echo esc_html( $rdtheme_typo_h6['font-weight'] ); ?>;
	font-style: <?php echo empty( $rdtheme_typo_h6['font-style'] ) ? 'normal' : $rdtheme_typo_h6['font-style']; ?>;
}

<?php
/*-------------------------------------
#. Page Options
---------------------------------------*/
?>
.content-area {
	padding-top: <?php echo esc_html( RDTheme::$padding_top );?>px;
	padding-bottom: <?php echo esc_html( RDTheme::$padding_bottom );?>px;
}
.entry-banner {
<?php if ( RDTheme::$bgtype == 'bgcolor' ): ?>
	background-color: <?php echo esc_html( RDTheme::$bgcolor );?>;
<?php else: ?>
	background: url(<?php echo esc_url( RDTheme::$bgimg );?>) no-repeat scroll center center / cover;
<?php endif; ?>
}

<?php
/*-------------------------------------
#. Inner Contents
---------------------------------------*/
?>
a:link,
a:visited,
.entry-footer .tags a:hover,
.about-author .media-body .author-title,
.entry-title h2 a:hover,
.seoengine-primary-color,
.related-cases .single-item-content h3 a:hover {
	color: <?php echo esc_html( $primary_color );?>;
}
blockquote,
.entry-header .entry-thumbnail-area .date span,
.comments-area .main-comments .replay-area a,
#respond form .btn-send,
.pagination-area ul li.active a,
.pagination-area ul li a:hover,
.pagination-area ul li .current,
.blog-style-2 .readmore-btn,
.seoengine-primary-bgcolor,
ul.seoengine-list li::before,
.team-detail-content ul.team-social li a:hover {
	background-color: <?php echo esc_html( $primary_color );?>;
}

.team-detail-content ul.team-social li a:hover {
	border-color: <?php echo esc_html( $primary_color );?>;
}

a:hover,
a:focus,
a:active {
	color: <?php echo esc_html( $secondery_color );?>;
}
.comments-area .main-comments .replay-area a:hover,
#respond form .btn-send:hover,
.blog-style-2 .readmore-btn:hover {
	background-color: <?php echo esc_html( $secondery_color );?>;
}
.ls-bar-timer {
	background-color: <?php echo esc_html( $primary_color );?>;
	border-bottom-color: <?php echo esc_html( $primary_color );?>;
}
<?php
/*-------------------------------------
#. Error 404
---------------------------------------*/
?>
.error-page-area {
    background-color: <?php echo esc_html( RDTheme::$options['error_bodybg'] );?>;
}
.error-page-area .error-page,
.error-page-area .error-page h3 {
	color: <?php echo esc_html( RDTheme::$options['error_text12_color'] );?>;
}

<?php
/*-------------------------------------
#. WooCommerce
---------------------------------------*/
?>
.product-grid-view .woo-shop-top .view-mode ul li:first-child .fa,
.product-list-view .woo-shop-top .view-mode ul li:last-child .fa,
.woocommerce ul.products li.product h3 a:hover,
.woocommerce ul.products li.product .price,
.woocommerce .product-thumb-area .product-info ul li a:hover .fa,
.woocommerce a.woocommerce-review-link:hover,
.woocommerce div.product p.price, .woocommerce div.product span.price,
.woocommerce div.product .product-meta a:hover,
.woocommerce div.product .woocommerce-tabs ul.tabs li.active a,
.woocommerce-message::before,
.woocommerce-info::before {
	color: <?php echo esc_html( $primary_color );?>;
}

.woocommerce ul.products li.product .onsale,
.woocommerce span.onsale,
.woocommerce a.added_to_cart,
.woocommerce div.product form.cart .button,
.woocommerce #respond input#submit,
.woocommerce a.button,
.woocommerce button.button,
.woocommerce input.button,
p.demo_store,
.woocommerce #respond input#submit.disabled:hover, .woocommerce #respond input#submit:disabled:hover, .woocommerce #respond input#submit[disabled]:disabled:hover, .woocommerce a.button.disabled:hover, .woocommerce a.button:disabled:hover, .woocommerce a.button[disabled]:disabled:hover, .woocommerce button.button.disabled:hover, .woocommerce button.button:disabled:hover, .woocommerce button.button[disabled]:disabled:hover, .woocommerce input.button.disabled:hover, .woocommerce input.button:disabled:hover, .woocommerce input.button[disabled]:disabled:hover,
.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt,
.woocommerce-account .woocommerce-MyAccount-navigation ul li a {
	background-color: <?php echo esc_html( $primary_color );?>;
}

.woocommerce-message,
.woocommerce-info {
	border-color: <?php echo esc_html( $primary_color );?>;
}

.woocommerce .product-thumb-area .overlay {
    background-color: rgba(<?php echo esc_html( $primary_rgb );?>, 0.8);
}

<?php
/*-------------------------------------
#. Plugin: Contact Form 7
---------------------------------------*/
?>
.cf7-quote-submit input:hover {
	background-color: <?php echo esc_html( $primary_color );?> !important;
}
.contact-us-form .wpcf7-submit:hover,
.cf7-seo-check input[type="submit"]:hover {
	background-color: <?php echo esc_html( $secondery_color );?>;
}
.cf7-quote-submit input {
	border-color: <?php echo esc_html( $primary_color );?>;
}
.cf7-seo-check input[type="submit"] {
	background-color: <?php echo esc_html( $primary_color );?>;
}