<?php
$primary_color   = RDTheme::$options['primary_color']; // #26c6da
$secondery_color = RDTheme::$options['secondery_color']; // #19abbd
$primary_rgb     = RDTheme_Helper::hex2rgb( $primary_color ); // 38, 198, 218

/*-------------------------------------    
INDEX
===================================
#. VC: Owl Dots 3
#. VC: Owl Nav 3
#. VC: Owl Nav 4
#. VC: Owl Nav 5
#. VC: Posts 1
#. VC: Posts 2
#. VC: Posts 3
#. VC: Owl Case Slider 1
#. VC: Case Grid 1
#. VC: Owl Team 4
#. VC: CTA
#. VC: Team Grid 1
#. VC: Portfolio 1
#. VC: Portfolio 2
#. VC: Contact
#. VC Defaults: Accordian
#. VC: Widget
#. VC: Widget - Menu
#. VC: Widget - Testimonial
-------------------------------------*/
?>
<?php /*--- VC: Owl Dots 3 ---*/ ?>
.rt-owl-dot-3 .owl-theme .owl-dots .owl-dot.active span,
.rt-owl-dot-3 .owl-theme .owl-dots .owl-dot:hover span {
	background-color: <?php echo esc_html( $primary_color );?>;
}

<?php /*--- VC: Owl Nav 3 ---*/ ?>
.rt-owl-nav-3 .owl-custom-nav-title::after,
.rt-owl-nav-3 .owl-custom-nav .owl-prev:hover,
.rt-owl-nav-3 .owl-custom-nav .owl-next:hover {
	background-color: <?php echo esc_html( $primary_color );?>;
}

<?php /*--- VC: Owl Nav 4 ---*/ ?>
.rt-owl-nav-4 .owl-theme .owl-nav > div {
	border-color: <?php echo esc_html( $primary_color );?>;
}
.rt-owl-nav-4 .owl-theme .owl-nav > div:hover {
	background-color: <?php echo esc_html( $primary_color );?> !important;
}

<?php /*--- VC: Owl Nav 5 ---*/ ?>
.rt-owl-nav-5 .owl-theme .owl-nav > div:hover {
	color: <?php echo esc_html( $primary_color );?>;
}

<?php /*--- VC: Posts 1 ---*/ ?>
.rt-vc-posts-1 .rt-header .rt-thumbnail-area .rt-date,
.rt-vc-posts-1 .rt-title h3 a:hover {
	color: <?php echo esc_html( $primary_color );?>;
}
.rt-vc-posts-1 .rt-header .rt-thumbnail-area .rt-date span {
	background-color: <?php echo esc_html( $primary_color );?>;
}

<?php /*--- VC: Posts 2 ---*/ ?>
.rt-vc-posts-2 .rt-content h3 a:hover,
.rt-vc-posts-2 .rt-meta i {
	color: <?php echo esc_html( $primary_color );?>;
}

<?php /*--- VC: Posts 3 ---*/ ?>
.rt-vc-posts-3 .rt-content h3 a:hover,
.rt-vc-posts-3 .rt-cat a:hover {
	color: <?php echo esc_html( $primary_color );?>;
}

<?php /*--- VC: Owl Case Slider 1 ---*/ ?>
.rt-owl-case-1 .single-item .single-item-meta h3 a:hover {
	color: <?php echo esc_html( $primary_color );?>;
}

<?php /*--- VC: Case Grid 1 ---*/ ?>
.rt-case-grid-1 .rt-item-meta h3 a:hover {
	color: <?php echo esc_html( $primary_color );?>;
}

<?php /*--- VC: Owl Team 4 ---*/ ?>
.rt-owl-team-4 .rt-item .rt-content h3 a:hover,
.rt-owl-team-4 .rt-item .rt-content .rt-designation {
	color: <?php echo esc_html( $primary_color );?>;
}

<?php /*--- VC: CTA ---*/ ?>
.rt-cta-1.default {
	background-color: <?php echo esc_html( $primary_color );?>;
}

<?php /*--- VC: Team Grid 1 ---*/ ?>
.rt-team-grid-1 .vc-overly ul li a:hover {
	background-color: <?php echo esc_html( $primary_color );?>;
}
.rt-team-grid-1 .vc-meta h3 a:hover {
	color: <?php echo esc_html( $primary_color );?>;
}

<?php /*--- VC: Portfolio 1 ---*/ ?>
.rt-portfolio-1 .rt-portfolio-tab a {
    border-color: <?php echo esc_html( $primary_color );?>;
}
.rt-portfolio-1 .rt-portfolio-tab a:hover,
.rt-portfolio-1 .rt-portfolio-tab .current {
    background-color: <?php echo esc_html( $primary_color );?>;
}

<?php /*--- VC: Portfolio 2 ---*/ ?>
.rt-portfolio-2 .single-item .single-item-meta h3 a:hover {
	color: <?php echo esc_html( $primary_color );?>;
}

<?php /*--- VC: Contact ---*/ ?>
.rt-vc-contact ul li i,
.rt-vc-contact ul li a:hover {
    color: <?php echo esc_html( $primary_color );?>;
}

<?php /*--- VC Defaults: Accordian ---*/ ?>
.vc_tta-accordion .vc_tta-panel .vc_tta-panel-heading:focus a,
.vc_tta-accordion .vc_tta-panel .vc_tta-panel-heading:hover a,
.vc_tta-accordion .vc_active .vc_tta-panel-heading a {
	background-color: <?php echo esc_html( $primary_color );?> !important;
}

<?php /*--- VC: Widget ---*/ ?>
.rt-wid-menu .rt-title::after {
	background-color: <?php echo esc_html( $primary_color );?>;
}

<?php /*--- VC: Widget - Menu ---*/ ?>
.rt-wid-menu .rt-title::after,
.rt-wid-menu ul li a:hover,
.rt-wid-menu ul li.current-menu-item a {
	background-color: <?php echo esc_html( $primary_color );?>;
}

<?php /*--- VC: Widget - Testimonial ---*/ ?>
.rt-owl-wid-testimonial .owl-custom-nav .owl-prev:hover,
.rt-owl-wid-testimonial .owl-custom-nav .owl-next:hover {
	color : <?php echo esc_html( $primary_color );?>;
}
.rt-owl-wid-testimonial .rt-vc-sep {
	background-color: <?php echo esc_html( $primary_color );?>;
}