<?php
add_action( 'wp_enqueue_scripts', 'rdtheme_register_scripts', 12 );
if ( !function_exists( 'rdtheme_register_scripts' ) ) {
	function rdtheme_register_scripts(){
		/*CSS*/
		// owl.carousel CSS
		wp_register_style( 'owl-carousel',       RDTHEME_CSS_URL . 'owl.carousel.min.css', array(), SEOENGINE_VERSION );
		wp_register_style( 'owl-theme-default',  RDTHEME_CSS_URL . 'owl.theme.default.min.css', array(), SEOENGINE_VERSION );

		/*JS*/
		// owl.carousel.min js
		wp_register_script( 'owl-carousel',      RDTHEME_JS_URL . 'owl.carousel.min.js', array( 'jquery' ), SEOENGINE_VERSION, true );
		// counter js
		wp_register_script( 'waypoints',         RDTHEME_JS_URL . 'waypoints.min.js', array( 'jquery' ), SEOENGINE_VERSION, true );
		wp_register_script( 'counterup',         RDTHEME_JS_URL . 'jquery.counterup.min.js', array( 'jquery' ), SEOENGINE_VERSION, true );
		// Portfolio
		wp_register_script( 'isotope-pkgd',      RDTHEME_JS_URL . 'isotope.pkgd.min.js', array( 'jquery' ), SEOENGINE_VERSION, true );
		wp_register_script( 'seoengine-vc-portfolio',    RDTHEME_JS_URL . 'vc-portfolio.js', array( 'jquery' ), SEOENGINE_VERSION, true );
	}
}

add_action( 'wp_enqueue_scripts', 'rdtheme_enqueue_scripts', 15 );
if ( !function_exists( 'rdtheme_enqueue_scripts' ) ) {
	function rdtheme_enqueue_scripts() {
		/*CSS*/
		// Google fonts
		wp_enqueue_style( 'seoengine-gfonts',     RDTheme_Helper::fonts_url(), array(), SEOENGINE_VERSION );
		// Bootstrap CSS
		wp_enqueue_style( 'bootstrap',            RDTHEME_CSS_URL . 'bootstrap.min.css', array(), SEOENGINE_VERSION );
		// font-awesome CSS
		wp_enqueue_style( 'font-awesome',         RDTHEME_CSS_URL . 'font-awesome.min.css', array(), SEOENGINE_VERSION );
		// Meanmenu CSS
		wp_enqueue_style( 'meanmenu',             RDTHEME_CSS_URL . 'meanmenu.css', array(), SEOENGINE_VERSION );
		// main CSS
		wp_enqueue_style( 'seoengine-default',    RDTHEME_CSS_URL . 'default.css', array(), SEOENGINE_VERSION );
		// vc modules css
		wp_enqueue_style( 'seoengine-vc',         RDTHEME_CSS_URL . 'vc.css', array(), SEOENGINE_VERSION );
		// style CSS
		wp_enqueue_style( 'seoengine-style',      RDTHEME_CSS_URL . 'style.css', array(), SEOENGINE_VERSION );
		// responsive CSS
		wp_enqueue_style( 'seoengine-responsive', RDTHEME_CSS_URL . 'responsive.css', array(), SEOENGINE_VERSION );
		// variable style CSS
		ob_start();
		include RDTHEME_INC_DIR . 'variable-style.php';
		include RDTHEME_INC_DIR . 'variable-style-vc.php';
		$variable_css  = ob_get_clean();
		$variable_css .= wp_kses_post( RDTheme::$options['custom_css'] ); // custom css
		wp_add_inline_style( 'seoengine-responsive', $variable_css );

		/*JS*/
		// bootstrap js
		wp_enqueue_script( 'bootstrap',             RDTHEME_JS_URL . 'bootstrap.min.js', array( 'jquery' ), SEOENGINE_VERSION, true );
		// Meanmenu js
		wp_enqueue_script( 'jquery-meanmenu',       RDTHEME_JS_URL . 'jquery.meanmenu.min.js', array( 'jquery' ), SEOENGINE_VERSION, true );
		// Nav smooth scroll
		wp_enqueue_script( 'jquery-nav',            RDTHEME_JS_URL . 'jquery.nav.min.js', array( 'jquery' ), SEOENGINE_VERSION, true );
		// Comments
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
		// Cookie js
		wp_enqueue_script( 'js-cookie',             RDTHEME_JS_URL . 'js.cookie.min.js', array( 'jquery' ), SEOENGINE_VERSION, true );
		// main js
		wp_enqueue_script( 'seoengine-main',        RDTHEME_JS_URL . 'main.js', array( 'jquery' ), SEOENGINE_VERSION, true );

		// localize script
		$appendHtml = '';
		if ( RDTheme::$options['header_btn_txt'] && RDTheme::$options['header_btn_url'] ) {
			$appendHtml = '<li class="mean-append-area"><div class="rtin-append-inner"><a class="header-menu-btn" href="'.esc_url( RDTheme::$options['header_btn_url'] ).'">'.esc_html( RDTheme::$options['header_btn_txt'] ).'</a></div></li>';
		}

		$rdtheme_localize_data = array(
			'stickyMenu' => RDTheme::$options['sticky_menu'],
			'meanWidth'  => RDTheme::$options['resmenu_width'],
			'siteLogo'   => '<a href="' . esc_url( home_url( '/' ) ) . '" alt="' . esc_attr( get_bloginfo( 'title' ) ) . '"><img class="logo-small" src="'. esc_url( RDTheme::$options['logo']['url'] ).'" /></a>',
			'extraOffset' => RDTheme::$options['sticky_menu'] ? 70 : 0,
			'extraOffsetMobile' => RDTheme::$options['sticky_menu'] ? 52 : 0,
			'appendHtml'    => $appendHtml,
		);
		wp_localize_script( 'seoengine-main', 'SEOEngineObj', $rdtheme_localize_data );
	}
}

// Admin Scripts
add_action( 'admin_enqueue_scripts', 'rdtheme_admin_scripts', 12 );
if ( !function_exists( 'rdtheme_admin_scripts' ) ) {
	function rdtheme_admin_scripts(){
		wp_enqueue_style( 'seoengine-admin', RDTHEME_CSS_URL . 'admin.css', array(), SEOENGINE_VERSION );
	}
}