<?php
if ( ! class_exists( 'Redux' ) ) {
    return;
}

$opt_name = "seoengine";

$theme = wp_get_theme();
$args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name'             => $opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'disable_tracking' => true,
    'display_name'         => $theme->get( 'Name' ),
    // Name that appears at the top of your panel
    'display_version'      => $theme->get( 'Version' ),
    // Version that appears at the top of your panel
    'menu_type'            => 'submenu',
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu'       => true,
    // Show the sections below the admin menu item or not
    'menu_title'           => __( 'SEOEngine Options', 'seoengine' ),
    'page_title'           => __( 'SEOEngine Options', 'seoengine' ),
    // You will need to generate a Google API key to use this feature.
    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    //'google_api_key'       => 'AIzaSyC2GwbfJvi-WnYpScCPBGIUyFZF97LI0xs',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography'     => true,
    // Use a asynchronous font on the front end or font string
    //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
    'admin_bar'            => true,
    // Show the panel pages on the admin bar
    'admin_bar_icon'       => 'dashicons-menu',
    // Choose an icon for the admin bar menu
    'admin_bar_priority'   => 50,
    // Choose an priority for the admin bar menu
    'global_variable'      => '',
    // Set a different name for your global variable other than the opt_name
    'dev_mode'             => false,
    'forced_dev_mode_off'  => false,
    // Show the time the page took to load, etc
    'update_notice'        => false,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer'           => true,
    // Enable basic customizer support
    //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
    //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

    // OPTIONAL -> Give you extra features
    'page_priority'        => null,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent'          => 'themes.php',
    // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions'     => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon'            => '',
    // Specify a custom URL to an icon
    'last_tab'             => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon'            => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug'            => 'seoengine-options',
    // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults'        => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show'         => true,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark'         => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export'   => true,
    // Shows the Import/Export panel when not used as a field.

    // CAREFUL -> These options are for advanced use only
    'transient_time'       => 60 * MINUTE_IN_SECONDS,
    'output'               => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag'           => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
    // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database'             => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn'              => true,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.
);

Redux::setArgs( $opt_name, $args );

// Fields
Redux::setSection( $opt_name, array(
    'title'            => __( 'General', 'seoengine' ),
    'id'               => 'general_section',
    'heading'          => '',
    'icon'             => 'el el-network',
    'fields' => array(
        array(
            'id'       => 'primary_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Primary Color', 'seoengine' ),
            'default'  => '#26c6da',
        ), 
        array(
            'id'       => 'secondery_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Secondery/Hover Color', 'seoengine' ),
            'default'  => '#19abbd',
        ),
        array(
            'id'       => 'preloader',
            'type'     => 'switch',
            'title'    => __( 'Preloader', 'seoengine' ),
            'on'       => __( 'Enabled', 'seoengine' ),
            'off'      => __( 'Disabled', 'seoengine' ),
            'default'  => false,
        ),
        array(
            'id'       => 'preloader_image',
            'type'     => 'media',
            'title'    => __( 'Preloader Image', 'seoengine' ),
            'subtitle' => __( 'Please upload your choice of preloader image. Transparent GIF format is recommended', 'seoengine' ),
            'default'  => array(
                'url'=> RDTHEME_IMG_URL . 'preloder.gif'
            ),
            'required' => array( 'preloader', 'equals', true )
        ),
        array(
            'id'       => 'back_to_top',
            'type'     => 'switch',
            'title'    => __( 'Back to Top Arrow', 'seoengine' ),
            'on'       => __( 'Enabled', 'seoengine' ),
            'off'      => __( 'Disabled', 'seoengine' ),
            'default'  => true,
        ),
        array(
            'id'       => 'no_preview_image',
            'type'     => 'media',
            'title'    => __( 'Alternative Preview Image', 'seoengine' ),
            'subtitle' => __( 'This image will be used as preview image in some archive pages if no featured image exists', 'seoengine' ),
            'default'  => array(
                'url'=> RDTHEME_IMG_URL . 'noimage.jpg'
            ),
        ),
        array(
            'id'       => 'case_slug',
            'type'     => 'text',
            'title'    => __( 'Case Study Slug', 'seoengine' ),
            'subtitle' => __( 'Will be used as slug in Case Study breadcrumb', 'seoengine' ),
            'default'  => 'case',
        ),
        array(
            'id'       => 'team_slug',
            'type'     => 'text',
            'title'    => __( 'Team Slug', 'seoengine' ),
            'subtitle' => __( 'Will be used as slug in Team breadcrumb', 'seoengine' ),
            'default'  => 'team',
        ),
        array(
            'id'       => 'portfolio_slug',
            'type'     => 'text',
            'title'    => __( 'Porofolio Slug', 'seoengine' ),
            'subtitle' => __( 'Will be used as slug in Porofolio breadcrumb', 'seoengine' ),
            'default'  => 'portfolio',
        ),
    )            
) 
);

Redux::setSection( $opt_name, array(
    'title'            => __( 'Contact & Socials', 'seoengine' ),
    'id'               => 'socials_section',
    'heading'          => '',
    'desc'             => __( 'In case you want to hide any field, keep that field empty', 'seoengine' ),
    'icon'             => 'el el-twitter',
    'fields' => array(
        array(
            'id'       => 'phone',
            'type'     => 'text',
            'title'    => __( 'Phone', 'seoengine' ),
            'default'  => '+000000000',
        ),
        array(
            'id'       => 'email',
            'type'     => 'text',
            'title'    => __( 'Email', 'seoengine' ),
            'validate' => 'email',
            'default'  => 'info@radiustheme.com',
        ),
        array(
            'id'       => 'address',
            'type'     => 'textarea',
            'title'    => __( 'Address', 'seoengine' ),
            'default'  => '1PO Box, Collins Street West, Australia',
        ),
        array(
            'id'       => 'social_facebook',
            'type'     => 'text',
            'title'    => __( 'Facebook', 'seoengine' ),
            'default'  => '#',
        ),
        array(
            'id'       => 'social_twitter',
            'type'     => 'text',
            'title'    => __( 'Twitter', 'seoengine' ),
            'default'  => '#',
        ),
        array(
            'id'       => 'social_gplus',
            'type'     => 'text',
            'title'    => __( 'Google Plus', 'seoengine' ),
            'default'  => '#',
        ),
        array(
            'id'       => 'social_linkedin',
            'type'     => 'text',
            'title'    => __( 'Linkedin', 'seoengine' ),
            'default'  => '',
        ),
        array(
            'id'       => 'social_youtube',
            'type'     => 'text',
            'title'    => __( 'Youtube', 'seoengine' ),
            'default'  => '#',
        ),
        array(
            'id'       => 'social_pinterest',
            'type'     => 'text',
            'title'    => __( 'Pinterest', 'seoengine' ),
            'default'  => '',
        ),
        array(
            'id'       => 'social_instagram',
            'type'     => 'text',
            'title'    => __( 'Instagram', 'seoengine' ),
            'default'  => '',
        ),
        array(
            'id'       => 'social_skype',
            'type'     => 'text',
            'title'    => __( 'Skype', 'seoengine' ),
            'default'  => '',
        ),
        array(
            'id'       => 'social_rss',
            'type'     => 'text',
            'title'    => __( 'RSS', 'seoengine' ),
            'default'  => '#',
        ),
    )            
    ) );

Redux::setSection( $opt_name, array(
    'title'            => __( 'Header', 'seoengine' ),
    'id'               => 'header_section',
    'heading'          => '',
    'icon'             => 'el el-caret-up',
    'fields' => array(
        array(
            'id'       => 'logo',
            'type'     => 'media',
            'title'    => __( 'Main Logo', 'seoengine' ),
            'default'  => array(
                'url'=> RDTHEME_IMG_URL . 'logo-dark.png'
            ),
        ),
        array(
            'id'       => 'logo_light',
            'type'     => 'media',
            'title'    => __( 'Light Logo', 'seoengine' ),
            'default'  => array(
                'url'=> RDTHEME_IMG_URL . 'logo-light.png'
            ),
            'subtitle' => __( 'Used when Transparent Header is enabled', 'seoengine' ),
        ),
        array(
            'id'       => 'logo_width',
            'type'     => 'select',
            'title'    => __( 'Logo Area Width', 'seoengine'), 
            'subtitle' => __( 'Width is defined by the number of bootstrap columns. Please note, navigation menu width will be decreased with the increase of logo width', 'seoengine' ),
            'options'  => array(
                '1' => __( '1 Column', 'seoengine' ),
                '2' => __( '2 Column', 'seoengine' ),
                '3' => __( '3 Column', 'seoengine' ),
                '4' => __( '4 Column', 'seoengine' ),
            ),
            'default'  => '2',
        ),
        array(
            'id'       => 'logo_fixed_height',
            'type'     => 'switch',
            'title'    => __( 'Fixed Height Logo', 'seoengine'), 
            'subtitle' => __( "Disable only if you want to display the same logo size you uploaded. If you are going to disable it, it's recommended that you upload a logo which height is less than 60px", 'seoengine' ),
            'on'       => __( 'Enabled', 'seoengine' ),
            'off'      => __( 'Disabled', 'seoengine' ),
            'default'  => true,
            ),
        array(
            'id'       => 'logo_fixed_height_sticky',
            'type'     => 'switch',
            'title'    => __( 'Fixed Height Logo (in sticky menu)', 'seoengine'), 
            'subtitle' => __( "Disable only if you want to display the same logo size you uploaded. If you are going to disable it, it's recommended that you upload a logo which height is less than 60px", 'seoengine' ),
            'on'       => __( 'Enabled', 'seoengine' ),
            'off'      => __( 'Disabled', 'seoengine' ),
            'default'  => true,
            ),
        array(
            'id'       => 'sticky_menu',
            'type'     => 'switch',
            'title'    => __( 'Sticky Header', 'seoengine' ),
            'on'       => __( 'Enabled', 'seoengine' ),
            'off'      => __( 'Disabled', 'seoengine' ),
            'default'  => true,
            'subtitle' => __( 'Show header when scroll down', 'seoengine' ),
        ), 
        array(
            'id'       => 'tr_header',
            'type'     => 'switch',
            'title'    => __( 'Transparent Header', 'seoengine' ),
            'on'       => __( 'Enabled', 'seoengine' ),
            'off'      => __( 'Disabled', 'seoengine' ),
            'default'  => false,
            'subtitle' => __( 'You have to enable Banner or Slider in page to make it work properly. You can override this settings in individual pages', 'seoengine' ),
        ),
        array(
            'id'       => 'top_bar',
            'type'     => 'switch',
            'title'    => __( 'Top Bar', 'seoengine' ),
            'on'       => __( 'Enabled', 'seoengine' ),
            'off'      => __( 'Disabled', 'seoengine' ),
            'default'  => false,
            'subtitle' => __( 'You can override this settings in individual pages', 'seoengine' ),
        ),
        array(
            'id'       => 'top_bar_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Top Bar Text Color', 'seoengine' ),
            'default'  => '#a6b1b7',
        ),
        array(
            'id'       => 'top_bar_color_tr',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Transparent Top Bar Text Color', 'seoengine' ),
            'subtitle' => __( 'Applied when Transparent Header is enabled', 'seoengine' ),
            'default'  => '#efefef',
        ),
        array(
            'id'       => 'top_bar_bgcolor',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Top Bar Background Color', 'seoengine' ),
            'default'  => '#222222',
        ),
        array(
            'id'       => 'top_bar_style',
            'type'     => 'image_select',
            'title'    => __( 'Top Bar Layout', 'seoengine' ),
            'default'  => '1',
            'options' => array(
                '1' => array(
                    'title' => '<b>'. __( 'Layout 1', 'seoengine' ) . '</b>',
                    'img' => RDTHEME_IMG_URL . 'top1.jpg',
                ),
                '2' => array(
                    'title' => '<b>'. __( 'Layout 2', 'seoengine' ) . '</b>',
                    'img' => RDTHEME_IMG_URL . 'top2.jpg',
                ),
                '3' => array(
                    'title' => '<b>'. __( 'Layout 3', 'seoengine' ) . '</b>',
                    'img' => RDTHEME_IMG_URL . 'top3.jpg',
                ),
            ),
            'subtitle' => __( 'You can override this settings in individual pages', 'seoengine' ),
        ),
        array(
            'id'       => 'header_style',
            'type'     => 'image_select',
            'title'    => __( 'Header Layout', 'seoengine' ),
            'default'  => '1',
            'options' => array(
                '1' => array(
                    'title' => '<b>'. __( 'Layout 1', 'seoengine' ) . '</b>',
                    'img' => RDTHEME_IMG_URL . 'header-1.jpg',
                ),
                '2' => array(
                    'title' => '<b>'. __( 'Layout 2', 'seoengine' ) . '</b>',
                    'img' => RDTHEME_IMG_URL . 'header-2.jpg',
                ),
                '3' => array(
                    'title' => '<b>'. __( 'Layout 3', 'seoengine' ) . '</b>',
                    'img' => RDTHEME_IMG_URL . 'header-3.jpg',
                ),
                '4' => array(
                    'title' => '<b>'. __( 'Layout 4', 'seoengine' ) . '</b>',
                    'img' => RDTHEME_IMG_URL . 'header-4.jpg',
                ),
                '5' => array(
                    'title' => '<b>'. __( 'Layout 5', 'seoengine' ) . '</b>',
                    'img' => RDTHEME_IMG_URL . 'header-5.jpg',
                ),
            ),
            'subtitle' => __( 'You can override this settings in individual pages', 'seoengine' ),
        ),
        array(
            'id'       => 'header_btn_txt',
            'type'     => 'text',
            'title'    => __( 'Header Button Text', 'seoengine' ),
            'subtitle' => __( 'Only used in Header Layout-5', 'seoengine' ),
            'default'  => __( 'FREE CONSULTING', 'seoengine' ),
        ),
        array(
            'id'       => 'header_btn_url',
            'type'     => 'text',
            'title'    => __( 'Header Button URL', 'seoengine' ),
            'subtitle' => __( 'Only used in Header Layout-5', 'seoengine' ),
            'default'  => '#',
        ),
        array(
            'id'       => 'search_icon',
            'type'     => 'switch',
            'title'    => __( 'Search Icon', 'seoengine' ),
            'on'       => __( 'Enabled', 'seoengine' ),
            'off'      => __( 'Disabled', 'seoengine' ),
            'default'  => true,
        ), 
        array(
            'id'       => 'cart_icon',
            'type'     => 'switch',
            'title'    => __( 'Cart Icon', 'seoengine' ),
            'on'       => __( 'Enabled', 'seoengine' ),
            'off'      => __( 'Disabled', 'seoengine' ),
            'default'  => true,
        ), 
        array(
            'id'       => 'vertical_menu_icon',
            'type'     => 'switch',
            'title'    => __( 'Vertical Menu Icon', 'seoengine' ),
            'on'       => __( 'Enabled', 'seoengine' ),
            'off'      => __( 'Disabled', 'seoengine' ),
            'default'  => true,
        ),
    )            
) 
);

Redux::setSection( $opt_name, array(
    'title'            => __( 'Main Menu', 'seoengine' ),
    'id'               => 'menu_section',
    'heading'          => '',
    'icon'             => 'el el-book',
    'fields' => array(
        array(
            'id'       => 'section-mainmenu',
            'type'     => 'section',
            'title'    => __( 'Main Menu Items', 'seoengine' ),
            'indent'   => true,
        ),
        array(
            'id'       => 'menu_typo',
            'type'     => 'typography',
            'title'    => __( 'Menu Font', 'seoengine' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Poppins',
                'google'      => true,
                'font-size'   => '16px',
                'font-weight' => '500',
                'line-height' => '24px',
            ),
        ),
        array(
            'id'       => 'menu_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Menu Color', 'seoengine' ),
            'default'  => '#222222',
        ),
        array(
            'id'       => 'menu_color_tr',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Transparent Menu Color', 'seoengine' ),
            'subtitle' => __( 'Applied when Transparent Header is enabled', 'seoengine' ),
            'default'  => '#fff',
        ),
        array(
            'id'       => 'menu_hover_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Menu Hover Color', 'seoengine' ),
            'default'  => '#26c6da',
        ),
        array(
            'id'       => 'section-submenu',
            'type'     => 'section',
            'title'    => __( 'Sub Menu Items', 'seoengine' ),
            'indent'   => true,
        ), 
        array(
            'id'       => 'submenu_typo',
            'type'     => 'typography',
            'title'    => __( 'Submenu Font', 'seoengine' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Poppins',
                'google'      => true,
                'font-size'   => '15px',
                'font-weight' => '500',
                'line-height' => '21px',
            ),
        ),
        array(
            'id'       => 'submenu_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Submenu Color', 'seoengine' ),
            'default'  => '#ffffff',
        ), 
        array(
            'id'       => 'submenu_bgcolor',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Submenu Background Color', 'seoengine' ),
            'default'  => '#26c6da',
        ),  
        array(
            'id'       => 'submenu_hover_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Submenu Hover Color', 'seoengine' ),
            'default'  => '#071041',
        ), 
        array(
            'id'       => 'submenu_hover_bgcolor',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Submenu Hover Background Color', 'seoengine' ),
            'default'  => '#26c6da',
        ),
        array(
            'id'       => 'section-resmenu',
            'type'     => 'section',
            'title'    => __( 'Mobile Menu', 'seoengine' ),
            'indent'   => true,
        ), 
        array(
            'id'       => 'resmenu_width',
            'type'     => 'slider',
            'title'    => __( 'Screen width in which mobile menu activated', 'seoengine' ),
            'subtitle' => __( 'Recommended value is: 991', 'seoengine' ),
            'default'  => 991,
            'min'      => 0,
            'step'     => 1,
            'max'      => 2000,
        ),
        array(
            'id'       => 'resmenu_typo',
            'type'     => 'typography',
            'title'    => __( 'Mobile Menu Font', 'seoengine' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Poppins',
                'google'      => true,
                'font-size'   => '14px',
                'font-weight' => '400',
                'line-height' => '21px',
            ),
        ),          
    )            
) 
);

Redux::setSection( $opt_name, array(
    'title'            => __( 'Banner', 'seoengine' ),
    'id'               => 'banner_section',
    'heading'          => '',
    'icon'             => 'el el-flag',
    'fields' => array(
        array(
            'id'       => 'banner_heading_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Banner Heading Color', 'seoengine' ),
            'default'  => '#ffffff',
        ), 
        array(
            'id'       => 'breadcrumb_link_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Breadcrumb Link Color', 'seoengine' ),
            'default'  => '#eeebeb',
        ),
        array(
            'id'       => 'breadcrumb_link_hover_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Breadcrumb Link Hover Color', 'seoengine' ),
            'default'  => '#ffffff',
        ),
        array(
            'id'       => 'breadcrumb_active_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Active Breadcrumb Color', 'seoengine' ),
            'default'  => '#26c6da',
        ),
        array(
            'id'       => 'breadcrumb_seperator_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Breadcrumb Seperator Color', 'seoengine' ),
            'default'  => '#eeebeb',
        ),
    )            
) 
);

Redux::setSection( $opt_name, array(
    'title'            => __( 'Footer', 'seoengine' ),
    'id'               => 'footer_section',
    'heading'          => '',
    'icon'             => 'el el-caret-down',
    'fields' => array(
        array(
            'id'       => 'section-footer-area',
            'type'     => 'section',
            'title'    => __( 'Footer Area', 'seoengine' ),
            'indent'   => true,
        ),
        array(
            'id'       => 'footer_area',
            'type'     => 'switch',
            'title'    => __( 'Display Footer Area', 'seoengine' ),
            'on'       => __( 'Enabled', 'seoengine' ),
            'off'      => __( 'Disabled', 'seoengine' ),
            'default'  => true,
        ),
        array(
            'id'       => 'footer_column',
            'type'     => 'select',
            'title'    => __( 'Number of Columns', 'seoengine' ),
            'options'  => array(
                '1' => '1 Column',
                '2' => '2 Columns',
                '3' => '3 Columns',
                '4' => '4 Columns',
            ),
            'default'  => '4',
            'required' => array( 'footer_area', 'equals', true )
        ),
        array(
            'id'       => 'footer_bgcolor',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Footer Background Color', 'seoengine' ),
            'default'  => '#263238',
            'required' => array( 'footer_area', 'equals', true )
        ), 
        array(
            'id'       => 'footer_title_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Footer Title Text Color', 'seoengine' ),
            'default'  => '#ffffff',
            'required' => array( 'footer_area', 'equals', true )
        ), 
        array(
            'id'       => 'footer_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Footer Body Text Color', 'seoengine' ),
            'default'  => '#b3b3b3',
            'required' => array( 'footer_area', 'equals', true )
        ), 
        array(
            'id'       => 'footer_link_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Footer Body Link Color', 'seoengine' ),
            'default'  => '#e1e1e1',
            'required' => array( 'footer_area', 'equals', true )
        ), 
        array(
            'id'       => 'footer_link_hover_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Footer Body Link Hover Color', 'seoengine' ),
            'default'  => '#26c6da',
            'required' => array( 'footer_area', 'equals', true )
        ), 
        array(
            'id'       => 'section-copyright-area',
            'type'     => 'section',
            'title'    => __( 'Copyright Area', 'seoengine' ),
            'indent'   => true,
        ),
        array(
            'id'       => 'copyright_area',
            'type'     => 'switch',
            'title'    => __( 'Display Copyright Area', 'seoengine' ),
            'on'       => __( 'Enabled', 'seoengine' ),
            'off'      => __( 'Disabled', 'seoengine' ),
            'default'  => true,
        ),
        array(
            'id'       => 'copyright_bgcolor',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Copyright Background Color', 'seoengine' ),
            'default'  => '#212b30',
            'required' => array( 'copyright_area', 'equals', true )
        ),
        array(
            'id'       => 'copyright_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => __( 'Copyright Text Color', 'seoengine' ),
            'default'  => '#909da4',
            'required' => array( 'copyright_area', 'equals', true )
        ),
        array(
            'id'       => 'copyright_text',
            'type'     => 'textarea',
            'title'    => __( 'Copyright Text', 'seoengine' ),
            'default'  => '&copy; Copyright SEOEngine 2017. All Right Reserved. Designed and Developed by <a target="_blank" href="' . RDTHEME_AUTHOR_URI . '"  style="color:#fff;">RadiusTheme</a>',
            'required' => array( 'copyright_area', 'equals', true )
        ), 
        array(
            'id'       => 'footer_social',
            'type'     => 'switch',
            'title'    => __( 'Display Social Links', 'seoengine' ),
            'on'       => __( 'Enabled', 'seoengine' ),
            'off'      => __( 'Disabled', 'seoengine' ),
            'default'  => true,
            'required' => array( 'copyright_area', 'equals', true )
        ),
    )            
) );

Redux::setSection( $opt_name, array(
    'title'            => __( 'Typography', 'seoengine' ),
    'id'               => 'typo_section',
    'icon'             => 'el el-text-width',
    'fields' => array(
        array(
            'id'       => 'typo_body',
            'type'     => 'typography',
            'title'    => __( 'Body', 'seoengine' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Open Sans',
                'google'      => true,
                'font-size'   => '15px',
                'font-weight' => '400',
                'line-height' => '26px',
            ),
        ),
        array(
            'id'       => 'typo_h1',
            'type'     => 'typography',
            'title'    => __( 'Header h1', 'seoengine' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Poppins',
                'google'      => true,
                'font-size'   => '40px',
                'font-weight' => '500',
                'line-height'   => '44px',
            ),
        ),
        array(
            'id'       => 'typo_h2',
            'type'     => 'typography',
            'title'    => __( 'Header h2', 'seoengine' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Poppins',
                'google'      => true,
                'font-size'   => '28px',
                'font-weight' => '500',
                'line-height' => '31px',
            ),
        ),
        array(
            'id'       => 'typo_h3',
            'type'     => 'typography',
            'title'    => __( 'Header h3', 'seoengine' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Poppins',
                'google'      => true,
                'font-size'   => '20px',
                'font-weight' => '500',
                'line-height' => '26px',
            ),
        ),
        array(
            'id'       => 'typo_h4',
            'type'     => 'typography',
            'title'    => __( 'Header h4', 'seoengine' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Poppins',
                'google'      => true,
                'font-size'   => '16px',
                'font-weight' => '500',
                'line-height' => '18px',
            ),
        ),
        array(
            'id'       => 'typo_h5',
            'type'     => 'typography',
            'title'    => __( 'Header h5', 'seoengine' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Poppins',
                'google'      => true,
                'font-size'   => '14px',
                'font-weight' => '500',
                'line-height' => '16px',
            ),
        ),
        array(
            'id'       => 'typo_h6',
            'type'     => 'typography',
            'title'    => __( 'Header h6', 'seoengine' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Poppins',
                'google'      => true,
                'font-size'   => '12px',
                'font-weight' => '500',
                'line-height' => '14px',
            ),
        ),
    )            
) );

// Generate Common post type fields
function rdtheme_redux_post_type_fields( $prefix ){
    return array(
        array(
            'id'       => $prefix. '_layout',
            'type'     => 'button_set',
            'title'    => __( 'Layout', 'seoengine' ),
            'options'  => array(
                'left-sidebar'  => __( 'Left Sidebar', 'seoengine' ),
                'full-width'    => __( 'Full Width', 'seoengine' ),
                'right-sidebar' => __( 'Right Sidebar', 'seoengine' ),
            ),
            'default' => 'right-sidebar'
        ),
        array(
            'id'       => $prefix. '_padding_top',
            'type'     => 'text',
            'title'    => __( 'Content Padding Top', 'seoengine' ),
            'validate'  => 'numeric',
            'default' => '80',
        ),
        array(
            'id'       => $prefix. '_padding_bottom',
            'type'     => 'text',
            'title'    => __( 'Content Padding Bottom', 'seoengine' ),
            'validate'  => 'numeric',
            'default' => '80'
        ),
        array(
            'id'       => $prefix. '_banner',
            'type'     => 'switch',
            'title'    => __( 'Banner', 'seoengine' ),
            'on'       => __( 'Enabled', 'seoengine' ),
            'off'      => __( 'Disabled', 'seoengine' ),
            'default'  => true,
        ),
        array(
            'id'       => $prefix. '_breadcrumb',
            'type'     => 'switch',
            'title'    => __( 'Breadcrumb', 'seoengine' ),
            'on'       => __( 'Enabled', 'seoengine' ),
            'off'      => __( 'Disabled', 'seoengine' ),
            'default'  => true,
            'required' => array( $prefix. '_banner', 'equals', true )
        ),
        array(
            'id'       => $prefix. '_bgtype',
            'type'     => 'button_set',
            'title'    => __( 'Banner Background Type', 'seoengine' ),
            'options'  => array(
                'bgimg'    => __( 'Background Image', 'seoengine' ),
                'bgcolor'  => __( 'Background Color', 'seoengine' ),
            ),
            'default' => 'bgimg',
            'required' => array( $prefix. '_banner', 'equals', true )
        ),
        array(
            'id'       => $prefix. '_bgimg',
            'type'     => 'media',
            'title'    => __( 'Banner Background Image', 'seoengine' ),
            'default'  => array(
                'url'=> RDTHEME_IMG_URL . 'banner.jpg'
            ),
            'required' => array( $prefix. '_bgtype', 'equals', 'bgimg' )
        ), 
        array(
            'id'       => $prefix. '_bgcolor',
            'type'     => 'color',
            'title'    => __('Banner Background Color', 'seoengine'), 
            'validate' => 'color',
            'transparent' => false,
            'default' => '#606060',
            'required' => array( $prefix. '_bgtype', 'equals', 'bgcolor' )
        ),
    );
}

Redux::setSection( $opt_name, array(
    'title'            => __( 'Layout Defaults', 'seoengine' ),
    'id'               => 'layout_defaults',
    'icon'             => 'el el-th',
    ) );

// Page
$rdtheme_page_fields = rdtheme_redux_post_type_fields( 'page' );
$rdtheme_page_fields[0]['default'] = 'full-width';
Redux::setSection( $opt_name, array(
    'title'            => __( 'Page', 'seoengine' ),
    'id'               => 'pages_section',
    'subsection' => true,
    'fields' => $rdtheme_page_fields     
    ) );


//Post Archive
$rdtheme_post_archive_fields = rdtheme_redux_post_type_fields( 'blog' );
Redux::setSection( $opt_name, array(
    'title'            => __( 'Blog / Archive', 'seoengine' ),
    'id'               => 'blog_section',
    'subsection' => true,
    'fields' => $rdtheme_post_archive_fields
    ) );


// Single Post
$rdtheme_single_post_fields = rdtheme_redux_post_type_fields( 'single_post' );
Redux::setSection( $opt_name, array(
    'title'            => __( 'Post Single', 'seoengine' ),
    'id'               => 'single_post_section',
    'subsection' => true,
    'fields' => $rdtheme_single_post_fields           
    ) );

// Single Case Study
$rdtheme_fields = rdtheme_redux_post_type_fields( 'case' );
Redux::setSection( $opt_name, array(
    'title'            => __( 'Single Case Study', 'seoengine' ),
    'id'               => 'single_case_section',
    'subsection' => true,
    'fields' => $rdtheme_fields           
    ) );

// Single Team
$rdtheme_fields = rdtheme_redux_post_type_fields( 'team' );
unset($rdtheme_fields[0]);
Redux::setSection( $opt_name, array(
    'title'            => __( 'Single Team', 'seoengine' ),
    'id'               => 'single_team_section',
    'subsection' => true,
    'fields' => $rdtheme_fields           
    ) );

// Single Portfolio
$rdtheme_fields = rdtheme_redux_post_type_fields( 'portfolio' );
unset($rdtheme_fields[0]);
Redux::setSection( $opt_name, array(
    'title'            => __( 'Single Portfolio', 'seoengine' ),
    'id'               => 'single_portfolio_section',
    'subsection' => true,
    'fields' => $rdtheme_fields           
    ) );

// Search
$rdtheme_search_fields = rdtheme_redux_post_type_fields( 'search' );
Redux::setSection( $opt_name, array(
    'title'            => __( 'Search Layout', 'seoengine' ),
    'id'               => 'search_section',
    'heading'          => '',
    'subsection' => true,
    'fields' => $rdtheme_search_fields            
) 
);

// Error 404 Layout
$rdtheme_error_fields = rdtheme_redux_post_type_fields( 'error' );
unset($rdtheme_error_fields[0]);
$rdtheme_error_fields[1]['default'] = '60';
$rdtheme_error_fields[2]['default'] = '60';
Redux::setSection( $opt_name, array(
    'title'   => __( 'Error 404 Layout', 'seoengine' ),
    'id'      => 'error_section',
    'heading' => '',
    'subsection' => true,
    'fields'  => $rdtheme_error_fields           
) 
);

if ( class_exists( 'WooCommerce' ) ) {
    // Woocommerce Shop Archive
    $rdtheme_shop_archive_fields = rdtheme_redux_post_type_fields( 'shop' );
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Shop Archive', 'seoengine' ),
        'id'               => 'shop_section',
        'subsection' => true,
        'fields' => $rdtheme_shop_archive_fields
        ) );

    // Woocommerce Product
    $rdtheme_product_fields = rdtheme_redux_post_type_fields( 'product' );
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Product Single', 'seoengine' ),
        'id'               => 'product_section',
        'subsection' => true,
        'fields' => $rdtheme_product_fields
        ) );
}

// Blog Settings
Redux::setSection( $opt_name, array(
    'title'            => __( 'Blog Settings', 'seoengine' ),
    'id'               => 'blog_settings_section',
    'icon'             => 'el el-tags',
    'heading'          => '',
    'fields' => array(
        array(
            'id'       =>'blog_style',
            'type'     => 'image_select',
            'title'    => __( 'Blog/Archive Layout', 'seoengine' ),
            'default'  => 'style1',
            'options' => array(
                'style1' => array(
                    'title' => '<b>'. __( 'Layout 1', 'seoengine' ) . '</b>',
                    'img' => RDTHEME_IMG_URL . 'blog1.png',
                ),
                'style2' => array(
                    'title' => '<b>'. __( 'Layout 2', 'seoengine' ) . '</b>',
                    'img' => RDTHEME_IMG_URL . 'blog2.png',
                ),
            ),
        ),
        array(
            'id'       => 'blog_date',
            'type'     => 'switch',
            'title'    => __( 'Show Date', 'seoengine' ),
            'on'       => __( 'On', 'seoengine' ),
            'off'      => __( 'Off', 'seoengine' ),
            'default'  => true,
        ), 
        array(
            'id'       => 'blog_author_name',
            'type'     => 'switch',
            'title'    => __( 'Show Author Name', 'seoengine' ),
            'on'       => __( 'On', 'seoengine' ),
            'off'      => __( 'Off', 'seoengine' ),
            'default'  => true,
        ),
        array(
            'id'       => 'blog_comment_num',
            'type'     => 'switch',
            'title'    => __( 'Show Comment Number', 'seoengine' ),
            'on'       => __( 'On', 'seoengine' ),
            'off'      => __( 'Off', 'seoengine' ),
            'default'  => true,
        ), 
        array(
            'id'       => 'blog_cats',
            'type'     => 'switch',
            'title'    => __( 'Show Categories', 'seoengine' ),
            'on'       => __( 'On', 'seoengine' ),
            'off'      => __( 'Off', 'seoengine' ),
            'default'  => true,
            'required' => array( 'blog_style', 'equals', 'style1' )
        ),
    )            
) 
);

// Post Settings
Redux::setSection( $opt_name, array(
    'title'            => __( 'Post Settings', 'seoengine' ),
    'id'               => 'post_settings_section',
    'icon'             => 'el el-file-edit',
    'heading'          => '',
    'fields' => array(
        array(
            'id'       => 'post_date',
            'type'     => 'switch',
            'title'    => __( 'Show Post Date', 'seoengine' ),
            'on'       => __( 'On', 'seoengine' ),
            'off'      => __( 'Off', 'seoengine' ),
            'default'  => true,
        ), 
        array(
            'id'       => 'post_comment_num',
            'type'     => 'switch',
            'title'    => __( 'Show Comment Number', 'seoengine' ),
            'on'       => __( 'On', 'seoengine' ),
            'off'      => __( 'Off', 'seoengine' ),
            'default'  => true,
        ), 
        array(
            'id'       => 'post_cats',
            'type'     => 'switch',
            'title'    => __( 'Show Categories', 'seoengine' ),
            'on'       => __( 'On', 'seoengine' ),
            'off'      => __( 'Off', 'seoengine' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_tags',
            'type'     => 'switch',
            'title'    => __( 'Show Tags', 'seoengine' ),
            'on'       => __( 'On', 'seoengine' ),
            'off'      => __( 'Off', 'seoengine' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_social',
            'type'     => 'switch',
            'title'    => __( 'Show Social Shares', 'seoengine' ),
            'on'       => __( 'On', 'seoengine' ),
            'off'      => __( 'Off', 'seoengine' ),
            'default'  => true,
        ),
        array(
            'id'      => 'post_share',
            'type'    => 'checkbox',
            'class'   => function_exists( 'ADDTOANY_SHARE_SAVE_KIT' ) ? 'redux-custom-inline hide' : 'redux-custom-inline',
            'title'   => esc_html__( 'Social Sharing Icons', 'classipost'), 
            'options' => array(
                'facebook'  => 'Facebook',
                'twitter'   => 'Twitter',
                'gplus'     => 'Google Plus',
                'linkedin'  => 'Linkedin',
                'pinterest' => 'Pinterest',
                'tumblr'    => 'Tumblr',
                'reddit'    => 'Reddit',
                'vk'        => 'Vk',
            ),
            'default' => array(
                'facebook'  => '1',
                'twitter'   => '1',
                'gplus'     => '1',
                'linkedin'  => '1',
                'pinterest' => '0',
                'tumblr'    => '0',
                'reddit'    => '0',
                'vk'        => '0',
            ),
            'required' => array( 'post_social', '=', true )
        ),
        array(
            'id'       => 'post_author_name',
            'type'     => 'switch',
            'title'    => __( 'Show Author Name', 'seoengine' ),
            'on'       => __( 'On', 'seoengine' ),
            'off'      => __( 'Off', 'seoengine' ),
            'default'  => true,
        ), 
        array(
            'id'       => 'post_author_bio',
            'type'     => 'switch',
            'title'    => __( 'Show Author Bio', 'seoengine' ),
            'on'       => __( 'On', 'seoengine' ),
            'off'      => __( 'Off', 'seoengine' ),
            'default'  => true,
        ),
    )            
) 
);

// Error
$rdtheme_fields2 = array( 
    array(
        'id'       => 'error_title',
        'type'     => 'text',
        'title'    => __( 'Page Title', 'seoengine' ),
        'default'  => __( 'Error 404', 'seoengine' ),
    ), 
    array(
        'id'       => 'error_bodybg',
        'type'     => 'color',
        'transparent' => false,
        'title'    => __( 'Body Background Color', 'seoengine' ),
        'default'  => '#26c6da',
    ), 
    array(
        'id'       => 'error_bodybanner',
        'type'     => 'media',
        'title'    => __( 'Body Banner', 'seoengine' ),
        'subtitle' => __( 'Upload your preferred image. PNG format is recommended', 'seoengine' ),
        'default'  => array(
            'url'=> RDTHEME_IMG_URL . '404.png'
        ),
    ), 
    array(
        'id'       => 'error_text1',
        'type'     => 'text',
        'title'    => __( 'Body Text 1', 'seoengine' ),
        'default'  => __( 'Page not Found', 'seoengine' ),
    ),
    array(
        'id'       => 'error_text2',
        'type'     => 'text',
        'title'    => __( 'Body Text 2', 'seoengine' ),
        'default'  => __( 'The page you are looking for is not available or has been removed. Try going to Home Page by using the button below.', 'seoengine' ),
    ),
    array(
        'id'       => 'error_text12_color',
        'type'     => 'color',
        'transparent' => false,
        'title'    => __( 'Body Text 1,2 Color', 'seoengine' ),
        'default'  => '#ffffff',
    ),    
    array(
        'id'       => 'error_buttontext',
        'type'     => 'text',
        'title'    => __( 'Button Text', 'seoengine' ),
        'default'  => __( 'Go to Home Page', 'seoengine' ),
    )
);
Redux::setSection( $opt_name, array(
    'title'   => __( 'Error Page Settings', 'seoengine' ),
    'id'      => 'error_srttings_section',
    'heading' => '',
    'icon'    => 'el el-error-alt',
    'fields'  => $rdtheme_fields2           
) 
);

if ( class_exists( 'WooCommerce' ) ) {
    // Woocommerce Settings
    Redux::setSection( $opt_name, array(
        'title'   => __( 'WooCommerce', 'seoengine' ),
        'id'      => 'woo_Settings_section',
        'heading' => '',
        'icon'    => 'el el-shopping-cart',
        'fields'  => array(
            array(
                'id'       => 'wc_sec_general',
                'type'     => 'section',
                'title'    => __( 'General', 'seoengine' ),
                'indent'   => true,
            ),
            array(
                'id'       => 'wc_num_product',
                'type'     => 'text',
                'title'    => __( 'Number of Products Per Page', 'seoengine' ),
                'default'  => '9',
            ),
            array(
                'id'       => 'wc_product_hover',
                'type'     => 'switch',
                'title'    => __( 'Product Hover Effect', 'seoengine' ),
                'on'       => __( 'Enabled', 'seoengine' ),
                'off'      => __( 'Disabled', 'seoengine' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_wishlist_icon',
                'type'     => 'switch',
                'title'    => __( 'Product Add to Wishlist Icon', 'seoengine' ),
                'on'       => __( 'Enabled', 'seoengine' ),
                'off'      => __( 'Disabled', 'seoengine' ),
                'default'  => true,
                'required' => array( 'wc_product_hover', 'equals', true )
            ),
            array(
                'id'       => 'wc_quickview_icon',
                'type'     => 'switch',
                'title'    => __( 'Product Quickview Icon', 'seoengine' ),
                'on'       => __( 'Enabled', 'seoengine' ),
                'off'      => __( 'Disabled', 'seoengine' ),
                'default'  => true,
                'required' => array( 'wc_product_hover', 'equals', true )
            ),
            array(
                'id'       => 'wc_sec_product',
                'type'     => 'section',
                'title'    => __( 'Product Single Page', 'seoengine' ),
                'indent'   => true,
            ),
            array(
                'id'       => 'wc_show_excerpt',
                'type'     => 'switch',
                'title'    => __( "Show excerpt when short description doesn't exist", 'seoengine' ),
                'on'       => __( 'Enabled', 'seoengine' ),
                'off'      => __( 'Disabled', 'seoengine' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_cats',
                'type'     => 'switch',
                'title'    => __( 'Categories', 'seoengine' ),
                'on'       => __( 'Show', 'seoengine' ),
                'off'      => __( 'Hide', 'seoengine' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_tags',
                'type'     => 'switch',
                'title'    => __( 'Tags', 'seoengine' ),
                'on'       => __( 'Show', 'seoengine' ),
                'off'      => __( 'Hide', 'seoengine' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_related',
                'type'     => 'switch',
                'title'    => __( 'Related Products', 'seoengine' ),
                'on'       => __( 'Show', 'seoengine' ),
                'off'      => __( 'Hide', 'seoengine' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_description',
                'type'     => 'switch',
                'title'    => __( 'Description Tab', 'seoengine' ),
                'on'       => __( 'Show', 'seoengine' ),
                'off'      => __( 'Hide', 'seoengine' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_reviews',
                'type'     => 'switch',
                'title'    => __( 'Reviews Tab', 'seoengine' ),
                'on'       => __( 'Show', 'seoengine' ),
                'off'      => __( 'Hide', 'seoengine' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_additional_info',
                'type'     => 'switch',
                'title'    => __( 'Additional Information Tab', 'seoengine' ),
                'on'       => __( 'Show', 'seoengine' ),
                'off'      => __( 'Hide', 'seoengine' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_sec_cart',
                'type'     => 'section',
                'title'    => __( 'Cart Page', 'seoengine' ),
                'indent'   => true,
            ),
            array(
                'id'       => 'wc_cross_sell',
                'type'     => 'switch',
                'title'    => __( 'Cross Sell Products', 'seoengine' ),
                'on'       => __( 'Show', 'seoengine' ),
                'off'      => __( 'Hide', 'seoengine' ),
                'default'  => true,
            ),
        )
) 
);
}

Redux::setSection( $opt_name, array(
    'title'   => __( 'Advanced', 'seoengine' ),
    'id'      => 'advanced_section',
    'heading' => '',
    'icon'    => 'el el-css',
    'fields'  => array(
        array(
            'id'       => 'custom_css',
            'type'     => 'ace_editor',
            'title'    => __( 'Custom CSS', 'seoengine' ),
            'subtitle' => __( 'Paste your CSS code here.', 'seoengine' ),
            'mode'     => 'css',
            'theme'    => 'chrome',
            'default'  => "body{\n   margin: 0 auto;\n}",
            'options'    => array('minLines' => 30)
        ),
    )
) 
);

// -> END Fields


// If Redux is running as a plugin, this will remove the demo notice and links
add_action( 'redux/loaded', 'rdtheme_remove_demo' );
/**
 * Removes the demo link and the notice of integrated demo from the redux-framework plugin
 */
if ( ! function_exists( 'rdtheme_remove_demo' ) ) {
    function rdtheme_remove_demo() {
        // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
        if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
            remove_filter( 'plugin_row_meta', array(
                ReduxFrameworkPlugin::instance(),
                'plugin_metalinks'
                ), null, 2 );

            // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
            remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
        }
    }
}