<?php
if ( !class_exists( 'RDTheme_Helper' ) ) {
	
	class RDTheme_Helper {

		public static function pagination() {

			if( is_singular() )
				return;

			global $wp_query;

			/** Stop execution if there's only 1 page */
			if( $wp_query->max_num_pages <= 1 )
				return;

			$paged = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;
			$max   = intval( $wp_query->max_num_pages );

			/**	Add current page to the array */
			if ( $paged >= 1 )
				$links[] = $paged;

			/**	Add the pages around the current page to the array */
			if ( $paged >= 3 ) {
				$links[] = $paged - 1;
				$links[] = $paged - 2;
			}

			if ( ( $paged + 2 ) <= $max ) {
				$links[] = $paged + 2;
				$links[] = $paged + 1;
			}
			include RDTHEME_VIEW_DIR . 'pagination.php';
		}


		public static function comments_callback( $comment, $args, $depth ){
			include RDTHEME_VIEW_DIR . 'comments-callback.php';
		}

		public static function filter_content( $content ){
			// wp filters
			$content = wptexturize( $content );
			$content = convert_smilies( $content );
			$content = convert_chars( $content );
			$content = wpautop( $content );
			$content = shortcode_unautop( $content );

			// remove shortcodes
			$pattern= '/\[(.+?)\]/';
			$content = preg_replace( $pattern,'',$content );

			// remove tags
			$content = strip_tags( $content );

			return $content;
		}

		public static function get_current_post_content( $post = false ) {
			if ( !$post ) {
				$post = get_post();
			}
			$content = has_excerpt( $post->ID ) ? $post->post_excerpt : $post->post_content;
			$content = self::filter_content( $content );
			return $content;
		}

		public static function hex2rgb($hex) {
			$hex = str_replace("#", "", $hex);
			if(strlen($hex) == 3) {
				$r = hexdec(substr($hex,0,1).substr($hex,0,1));
				$g = hexdec(substr($hex,1,1).substr($hex,1,1));
				$b = hexdec(substr($hex,2,1).substr($hex,2,1));
			} else {
				$r = hexdec(substr($hex,0,2));
				$g = hexdec(substr($hex,2,2));
				$b = hexdec(substr($hex,4,2));
			}
			$rgb = "$r, $g, $b";
			return $rgb;
		}

		public static function filter_social( $args ){
			return ( $args['url'] != '' );
		}

		public static function fonts_url(){
			$fonts_url = '';
			if ( 'off' !== _x( 'on', 'Google fonts - Open Sans and Poppins : on or off', 'seoengine' ) ) {
				$fonts_url = add_query_arg( 'family', urlencode( 'Open Sans:400,400i,600,600i|Poppins:400,500,600,700&subset=latin,latin-ext' ), "//fonts.googleapis.com/css" );
			}
			return $fonts_url;
		}

		public static function small_excerpt(){
			return 35;
		}

		public static function socials(){
			$rdtheme_socials = array(
				'social_facebook' => array(
					'icon' => 'fa-facebook',
					'url'  => RDTheme::$options['social_facebook'],
				),
				'social_twitter' => array(
					'icon' => 'fa-twitter',
					'url'  => RDTheme::$options['social_twitter'],
				),
				'social_gplus' => array(
					'icon' => 'fa-google-plus',
					'url'  => RDTheme::$options['social_gplus'],
				),
				'social_linkedin' => array(
					'icon' => 'fa-linkedin',
					'url'  => RDTheme::$options['social_linkedin'],
				),
				'social_youtube' => array(
					'icon' => 'fa-youtube',
					'url'  => RDTheme::$options['social_youtube'],
				),
				'social_pinterest' => array(
					'icon' => 'fa-pinterest',
					'url'  => RDTheme::$options['social_pinterest'],
				),
				'social_instagram' => array(
					'icon' => 'fa-instagram',
					'url'  => RDTheme::$options['social_instagram'],
				),
				'social_skype' => array(
					'icon' => 'fa-skype',
					'url'  => RDTheme::$options['social_skype'],
				),
				'social_rss' => array(
					'icon' => 'fa-rss',
					'url'  => RDTheme::$options['social_rss'],
				),
			);
			return array_filter( $rdtheme_socials, array( 'RDTheme_Helper' , 'filter_social' ) );
		}

		public static function nav_menu_args(){
			$rdtheme_pagemenu = false;
			if ( ( is_single() || is_page() ) ) {
				$rdtheme_menuid = get_post_meta( get_the_id(), 'seoengine_page_menu', true );
				if ( !empty( $rdtheme_menuid ) && $rdtheme_menuid != 'default' ) {
					$rdtheme_pagemenu = $rdtheme_menuid;
				}
			}
			if ( $rdtheme_pagemenu ) {
				$nav_menu_args = array( 'menu' => $rdtheme_pagemenu,'container' => 'nav' );
			}
			else {
				$nav_menu_args = array( 'theme_location' => 'primary','container' => 'nav', 'fallback_cb' => 'false' );
			}
			return $nav_menu_args;		
		}

		public static function render_preloader(){
			if ( RDTheme::$options['preloader'] ){
				if ( !empty( RDTheme::$options['preloader_image']['url'] ) ) {
					$preloader_img = RDTheme::$options['preloader_image']['url'];
				}
				else {
					$preloader_img = RDTHEME_IMG_URL . 'preloder.gif';
				}
				echo '<div id="preloader" style="background-image:url(' . esc_url( $preloader_img ) . ');"></div>';
			}
		}
	}
}