<?php
if ( !isset( $content_width ) ) {
	$content_width = 1200;
}

// Setup theme default functionalities
add_action('after_setup_theme', 'rdtheme_setup');
if ( !function_exists( 'rdtheme_setup' ) ) {
	function rdtheme_setup() {
		// Language
		load_theme_textdomain( 'seoengine', RDTHEME_BASE_DIR . 'languages' );

		// Theme support
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption' ) );
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-lightbox' );

		// Image sizes
		add_image_size( 'rdtheme-size1', 1200, 600, true ); // post large
		add_image_size( 'rdtheme-size2', 336, 290, true ); // blog layout 2
		add_image_size( 'rdtheme-size3', 360, 400, true ); // team
		add_image_size( 'rdtheme-size4', 600, 300, true ); // vc posts
		add_image_size( 'rdtheme-size5', 390, 260, true ); // vc case
		add_image_size( 'rdtheme-size6', 180, 180, true ); // vc team
		add_image_size( 'rdtheme-size7', 360, 310, true ); // vc portfolio

		// Register menus
		register_nav_menus( array(
			'primary'  => esc_html__( 'Primary', 'seoengine' ),
			'topright' => esc_html__( 'Header Right', 'seoengine' ),
			) );
	}	
}

// Register Widget Areas
add_action( 'widgets_init', 'rdtheme_widgets_init' );
if ( !function_exists( 'rdtheme_widgets_init' ) ) {
	function rdtheme_widgets_init() {
		
		$footer_widget_titles = array(
			'1' => __( 'Footer 1', 'seoengine' ),
			'2' => __( 'Footer 2', 'seoengine' ),
			'3' => __( 'Footer 3', 'seoengine' ),
			'4' => __( 'Footer 4', 'seoengine' ),
		);

		register_sidebar( array(
			'name'          => __( 'Sidebar', 'seoengine' ),
			'id'            => 'sidebar',
			'before_widget' => '<div id="%1$s" class="widget %2$s single-sidebar padding-bottom1">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widgettitle">',
			'after_title'   => '</h3>',
			) );

		for ( $i = 1; $i <= RDTheme::$options['footer_column']; $i++ ) {
			register_sidebar( array(
				'name'          => $footer_widget_titles[$i],
				'id'            => 'footer-'. $i,
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widgettitle">',
				'after_title'   => '</h3>',
				) );		
		}
	}
}

// Body class
add_filter( 'body_class', 'rdtheme_body_classes' );
if( !function_exists( 'rdtheme_body_classes' ) ) {
	function rdtheme_body_classes( $classes ) {
		$classes[] = 'non-stick';

		$classes[] = 'header-style-'. RDTheme::$header_style;

		if ( RDTheme::$top_bar == 1 || RDTheme::$top_bar == 'on' ){
			$classes[] = 'has-topbar topbar-style-'. RDTheme::$top_bar_style;
		}        

		if ( RDTheme::$tr_header == 1 || RDTheme::$tr_header == 'on' ){
			$classes[] = 'trheader';
		}

		$classes[] = ( RDTheme::$layout == 'full-width' ) ? 'no-sidebar' : 'has-sidebar';

		if ( ( is_home() || ( is_archive() && get_post_type() == 'post' ) ) && RDTheme::$options['blog_style'] == 'style2' ) {
			$classes[] = 'blog-style-2';
		}

		if( isset( $_COOKIE["shopview"] ) && $_COOKIE["shopview"] == 'list' ) {
			$classes[] = 'product-list-view';
		} else {
			$classes[] = 'product-grid-view';
		}

		return $classes;
	}
}

// Head Script
add_action( 'wp_head', 'rdtheme_head', 1 );
if( !function_exists( 'rdtheme_head' ) ) {
	function rdtheme_head(){
		// Hide preloader if js is disabled
		echo '<noscript><style>#preloader{display:none;}</style></noscript>';
	}	
}

// Footer Html
add_action( 'wp_footer', 'rdtheme_footer_html', 1 );
if( !function_exists( 'rdtheme_footer_html' ) ) {
	function rdtheme_footer_html(){
		// Back-to-top link
		if ( RDTheme::$options['back_to_top'] ){
			echo '<a href="#" class="scrollToTop"><i class="fa fa-arrow-up"></i></a>';
		}
	}	
}