<?php
$rdtheme_socials = RDTheme_Helper::socials();

$rdtheme_footer_column = RDTheme::$options['footer_column'];
switch ( $rdtheme_footer_column ) {
	case '1':
	$rdtheme_footer_class = 'col-sm-12 col-xs-12';
	break;
	case '2':
	$rdtheme_footer_class = 'col-sm-6 col-xs-12';
	break;
	case '3':
	$rdtheme_footer_class = 'col-sm-4 col-xs-12';
	break;		
	default:
	$rdtheme_footer_class = 'col-sm-3 col-xs-12';
	break;
}

$rdtheme_footer_left_class = RDTheme::$options['footer_social'] ? 'col-sm-8 col-xs-12' : 'col-sm-12 col-xs-12 text-center';
?>
</div><!-- #content -->
<footer>
	<?php if ( RDTheme::$options['footer_area'] ): ?>
		<div class="footer-top-area">
			<div class="container">
				<div class="row">
					<?php
					for ( $i = 1; $i <= $rdtheme_footer_column; $i++ ) {
						echo '<div class="' . $rdtheme_footer_class . '">';
						dynamic_sidebar( 'footer-'. $i );
						echo '</div>';
					}
					?>
				</div>
			</div>
		</div>			
	<?php endif; ?>
	<?php if ( RDTheme::$options['copyright_area'] ): ?>
		<div class="footer-bottom-area">
			<div class="container">
				<div class="row">
					<div class="<?php echo esc_attr( $rdtheme_footer_left_class );?>">
						<div class="footer-bottom-left"><?php echo wp_kses_post( RDTheme::$options['copyright_text'] );?></div>
					</div>
					<?php if ( RDTheme::$options['footer_social'] ): ?>
						<div class="col-sm-4 col-xs-12">
							<ul class="footer-bottom-right">
							<?php foreach ( $rdtheme_socials as $key => $rdtheme_social ): ?>
								<?php if ( $key == 'social_skype' ): ?>
									<li><a href="skype:<?php echo esc_attr( $rdtheme_social['url'] );?>?chat"><i class="fa <?php echo esc_attr( $rdtheme_social['icon'] );?>"></i></a></li>
								<?php else: ?>
									<li><a target="_blank" href="<?php echo esc_url( $rdtheme_social['url'] );?>"><i class="fa <?php echo esc_attr( $rdtheme_social['icon'] );?>"></i></a></li>
								<?php endif; ?>
							<?php endforeach; ?>
							</ul>
						</div>						
					<?php endif; ?>
				</div>
			</div>
		</div>
	<?php endif; ?>
</footer>
</div>
<?php wp_footer();?>
</body>
</html>