<?php

if (!class_exists('KcSeoSettings')):

    class KcSeoHelper
    {
        function verifyNonce() {
            $nonce = !empty($_REQUEST['_kcseo_nonce']) ? $_REQUEST['_kcseo_nonce'] : null;
            if (!wp_verify_nonce($nonce, $this->nonceText())) {
                return false;
            }

            return true;
        }

        function nonceText() {
            return "kcseo_nonce_secret_text";
        }


        function isValidBase64($string = null) {
            $decoded = @base64_decode($string, true);
            // Check if there is no invalid character in string
            if (!@preg_match('/^[a-zA-Z0-9\/\r\n+]*={0,2}$/', $string)) {
                return false;
            }

            // Decode the string in strict mode and send the response
            if (!@base64_decode($string, true)) {
                return false;
            }

            // Encode and compare it to original one
            if (@base64_encode($decoded) != $string) {
                return false;
            }

            return true;
        }


        function kcSeoPostTypes() {
            global $KcSeoWPSchema;
            $settings = get_option($KcSeoWPSchema->options['main_settings']);
            $post_types = !empty($settings['post-type']) ? $settings['post-type'] : array('post', 'page');

            return $post_types;
        }

        function get_post_type_list() {
            $post_types = get_post_types(
                array(
                    'public' => true
                )
            );
            $exclude = array('attachment', 'revision', 'nav_menu_item');
            foreach ($exclude as $ex) {
                unset($post_types[$ex]);
            }

            return $post_types;
        }

        /**
         * Sanitize field value
         *
         * @param array $field
         * @param null  $value
         *
         * @return array|null
         * @internal param $value
         */
        function sanitize($field = array(), $value = null) {
            $newValue = null;
            if (is_array($field) && $value) {
                $type = (!empty($field['type']) ? $field['type'] : 'text');
                if ($type == 'text' || $type == 'number' || $type == 'select' || $type == 'checkbox' || $type == 'radio') {
                    $newValue = sanitize_text_field($value);
                } else if ($type == 'url') {
                    $newValue = esc_url($value);
                } else if ($type == 'textarea') {
                    $newValue = wp_kses($value, array());
                } else {
                    $newValue = sanitize_text_field($value);
                }
            }

            return $newValue;
        }


        function sanitizeOutPut($value, $type = 'text') {
            $newValue = null;
            if ($value) {
                if ($type == 'text') {
                    $newValue = esc_html(stripslashes($value));
                } elseif ($type == 'url') {
                    $newValue = esc_url(stripslashes($value));
                } elseif ($type == 'textarea') {
                    $newValue = esc_textarea(stripslashes($value));
                } else {
                    $newValue = esc_html(stripslashes($value));
                }
            }

            return $newValue;
        }


        function imageInfo($attachment_id) {
            $data = array();
            $imgData = wp_get_attachment_metadata($attachment_id);
            $data['url'] = wp_get_attachment_url($attachment_id, "full");
            $data['width'] = !empty($imgData['width']) ? absint($imgData['width']) : 0;
            $data['height'] = !empty($imgData['height']) ? absint($imgData['height']) : 0;

            return $data;
        }

        static function filter_content($content) {
            $content = preg_replace('#\[[^\]]+\]#', '',$content);
            return $content;
        }

    }

endif;