<?php
if ( !class_exists( 'RDTheme_VC_WID_Menu' ) ) {

	class RDTheme_VC_WID_Menu extends RDTheme_VC_Modules {

		public function __construct(){
			$this->name = __( "SEOEngine Widget: Menu", 'seoengine-core' );
			$this->base = 'seoengine-vc-wid-menu';
			$this->translate = array(
				'title' => __( "Featured Services", 'seoengine-core' ),
			);
			parent::__construct();
		}

		public function fields(){

			$menus = wp_get_nav_menus();
			$nav_menus = array();
			foreach ( $menus as $menu ) {
				$nav_menus[$menu->name] = $menu->term_id;
			}

			$fields = array(
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Title", 'seoengine-core' ),
					"param_name" => "title",
					"value" => $this->translate['title'],
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Select Menu", 'seoengine-core' ),
					"param_name" => "menu",
					'value' => $nav_menus,
				),
			);
			return $fields;
		}

		public function shortcode( $atts, $content = '' ){
			extract( shortcode_atts( array(
				'title'    => $this->translate['title'],
				'menu'     => '',
				), $atts ) );

			$template = 'wid-menu';

			return $this->template( $template, get_defined_vars() );
		}
	}
}

new RDTheme_VC_WID_Menu;