<?php
$args = array(
    'post_type'        => 'seo_portfolio',
    'posts_per_page'   => -1,
    'suppress_filters' => false,
);
$posts = get_posts( $args );

$portfolio = array();
$cats    = array();

foreach ( $posts as $post ) {
    $cats_comma       = array();
    $img              = get_the_post_thumbnail_url( $post, 'rdtheme-size7' );
    $terms            = get_the_terms( $post, 'seo_portfolio_category' );
    $terms_html       = '';
    $terms_comma_html = '';

    foreach ( $terms as $term ) {
        $id = md5( $term->slug );
        $terms_html  .= ' ' . $id;
        $cats_comma[] = $term->name;
        if ( !isset( $cats[$id] ) ) {
            $cats[$id] = $term->name;
        }
    }

    $portfolio[] = array(
        'img'        => $img,
        'title'      => $post->post_title,
        'url'        => get_the_permalink( $post ),
        'cats'       => $terms_html,
        'cats_comma' => implode(", ", $cats_comma ),
    );
}

$class = ( $showinfo == 'always' ) ? 'rt-info-always' : 'rt-info-hidden';

if ( $showtitle == 'visible' ) {
    $col_tab = 'col-md-9 col-xs-12';
}
else {
    $col_tab = 'col-sm-12 col-xs-12';
    $class .= ' rt-notitle';
}
?>
<div class="rt-portfolio-1 <?php echo esc_attr( $class );?>">
    <div class="row">
        <?php if ( $showtitle == 'visible' ): ?>
            <div class="col-md-3 col-xs-12">
                <h3 class="rt-section-title"><?php echo esc_html( $title );?></h3>
            </div>
        <?php endif; ?>
        <div class="<?php echo esc_attr( $col_tab );?>">
            <div class="rt-portfolio-tab"> 
                <a href="#" data-filter="*" class="current"><?php echo esc_html( $all );?></a>
                <?php foreach ( $cats as $key => $value): ?>
                    <a href="#" data-filter=".<?php echo esc_attr( $key );?>"><?php echo esc_html( $value );?></a>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    <div class="row rt-portfolio-wrapper">
        <?php foreach ( $portfolio as $portfolio_each ): ?>
            <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12<?php echo esc_attr( $portfolio_each['cats'] );?>">
                <div class="rt-portfolio-box">
                    <img src="<?php echo esc_url( $portfolio_each['img'] );?>" alt="<?php echo esc_html( $portfolio_each['title'] );?>">
                    <div class="rt-portfolio-contents">
                        <h3><a href="<?php echo esc_url( $portfolio_each['url'] );?>"><?php echo esc_html( $portfolio_each['title'] );?></a></h3>
                        <span><?php echo esc_html( $portfolio_each['cats_comma'] );?></span>  
                    </div>
                </div>
            </div>
        <?php endforeach;?>
    </div>             
</div>