<?php
$class	     = "rt-counter-2-wrap ";
$class	    .= vc_shortcode_custom_css_class( $css );
$width_css   = !empty( $width ) ? 'max-width: '. $width . 'px;' : '';
$icon_css    = "font-size: {$icon_size}px;color:{$icon_color};";
$counter_css = "color:{$counter_color};";
if ( $spacing != '' ) {
	$spacing      = intval( $spacing );
	$counter_css .= "margin-bottom: {$spacing}px;";
}
$title_css   = "color:{$title_color};";
?>
<div class="<?php echo esc_attr( $class );?>">
	<div class="rt-counter-2" style="<?php echo esc_attr( $width_css );?>">
		<div class="rt-left">
			<?php if ( $icontype == 'image' ): ?>
				<?php echo wp_get_attachment_image( $image, array( $icon_size, $icon_size ), true );?>
			<?php else: ?>
				<i class="<?php echo esc_attr( $icon );?>" aria-hidden="true" style="<?php echo esc_attr( $icon_css );?>"></i>
			<?php endif; ?>
		</div>
		<div class="rt-right">
			<div class="rt-counter" style="<?php echo esc_attr( $counter_css );?>">
				<span class="rt-counter-num" data-num="<?php echo esc_html( $counter_number );?>" data-rtSpeed="<?php echo esc_html( $counter_speed );?>" data-rtSteps="<?php echo esc_html( $counter_steps );?>"><?php echo esc_html( $counter_number );?></span><?php echo esc_html( $counter_text );?>
			</div>
			<div class="rt-title" style="<?php echo esc_attr( $title_css );?>"><?php echo esc_html( $title );?></div>
		</div>
		<div class="clear"></div>
	</div>
</div>