<?php
$thumb_size = 'rdtheme-size5';
$args = array(
	'post_type'      => 'seo_case',
	'posts_per_page' => $slider_item_number,
	'orderby'        => $orderby,
);

if ( !empty( $cat ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => 'seo_case_category',
			'field' => 'term_id',
			'terms' => $cat,
		)
	);
}

switch ( $orderby ) {
	case 'title':
	case 'menu_order':
	$args['order'] = 'ASC';
	break;
}

$query = new WP_Query( $args );
$slider_nav_class = ( $slider_nav == 'true' ) ? ' slider-nav-enabled' : '';
?>
<div class="row">
	<div class="col-lg-12 col-md-12 col-sm-12">
		<div class="owl-wrap rt-owl-nav-4 rt-owl-dot-3 rt-owl-case-1<?php echo esc_attr( $slider_nav_class );?>">
			<div class="owl-theme owl-carousel rt-owl-carousel" data-carousel-options="<?php echo esc_attr( $owl_data );?>">
				<?php if ( $query->have_posts() ) :?>
					<?php while ( $query->have_posts() ) : $query->the_post();?>
						<?php
						$thumbnail = false;
						if ( has_post_thumbnail() ){
							$thumbnail = get_the_post_thumbnail( null, $thumb_size );
						}
						else {
							if ( !empty( RDTheme::$options['no_preview_image']['id'] ) ) {
								$thumbnail = wp_get_attachment_image( RDTheme::$options['no_preview_image']['id'], $thumb_size );
							}
							elseif ( !empty( RDTheme::$options['no_preview_image']['url'] ) ) {
								$thumbnail = '<img class="attachment-rdtheme-size5 size-rdtheme-size5 wp-post-image" src="'.RDTHEME_IMG_URL.'noimage_390_260.jpg" alt="'.get_the_title().'">';
							}
						}

						$content = RDTheme_Helper::get_current_post_content();
						$content = wp_trim_words( $content, 12 );
						?>
						<div class="single-item">
							<?php if ( $thumbnail ): ?>
								<div class="single-item-content">
									<div class="single-item-image">
										<?php echo $thumbnail;?>
									</div>
									<div class="details"><a class="rdtheme-button-1" href="<?php the_permalink();?>"><?php esc_html_e( 'Details', 'seoengine-core' );?></a></div>
									<div class="rt-overlay"></div>
								</div>
							<?php endif; ?>
							<div class="single-item-meta">
								<h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
								<div><?php echo $content;?></div>
							</div>
						</div>
					<?php endwhile;?>
				<?php endif;?>
				<?php wp_reset_query();?>
			</div>
		</div>
	</div>
</div>