<?php
$thumb_size = 'rdtheme-size5';

$args = array(
	'post_type'      => 'seo_case',
	'posts_per_page' => 3,
	'post__in'       => array( $item1, $item2, $item3 ),
	'orderby'        => 'post__in',
);

$query = new WP_Query( $args );
$count = 0;
?>
<div class="rt-case-box-1">
	<div class="row">
		<?php if ( $query->have_posts() ) :?>
			<?php while ( $query->have_posts() ) : $query->the_post();?>
				<?php
				$count++;
				$thumbnail = false;
				if ( has_post_thumbnail() ){
					$thumbnail = get_the_post_thumbnail( null, $thumb_size );
				}
				elseif( !empty( RDTheme::$options['no_preview_image']['id'] ) ) {
						$thumbnail = wp_get_attachment_image( RDTheme::$options['no_preview_image']['id'], $thumb_size );
				}
				else {
					$thumbnail = '<img class="attachment-rdtheme-size5 size-rdtheme-size5 wp-post-image" src="'.RDTHEME_IMG_URL.'noimage_390_260.jpg" alt="'.get_the_title().'">';
				}
				
				$h3_color = ${'h3color'.$count};

				$content = RDTheme_Helper::get_current_post_content();
				$content = wp_trim_words( $content, 50 );
				?>
				<div class="col-sm-4 p0 rt-count-<?php echo esc_attr( $count );?>">
					<div class="rt-item">
						<div class="rt-item-image rt-item-child">
							<a href="<?php the_permalink();?>"><?php echo $thumbnail;?></a>
						</div>
						<div class="rt-item-meta rt-item-child">
							<div class="rt-item-content">
								<h3><a style="color:<?php echo esc_attr( $h3_color );?>;" href="<?php the_permalink();?>"><?php the_title();?></a></h3>
								<div><?php echo $content;?></div>								
							</div>
						</div>
						<?php if ( $count == 2 ): ?>
							<div class="rt-item-image rt-item-child">
								<a href="<?php the_permalink();?>"><?php echo $thumbnail;?></a>
							</div>							
						<?php endif; ?>
					</div>
				</div>
			<?php endwhile;?>
		<?php endif;?>
	</div>
</div>
<?php wp_reset_query();?>