<?php
if ( !class_exists( 'RDTheme_VC_Testimonial' ) ) {

	class RDTheme_VC_Testimonial extends RDTheme_VC_Modules {

		public function __construct(){
			$this->name = __( "SEOEngine: Testimonials", 'seoengine-core' );
			$this->base = 'seoengine-vc-testimonial';
			$this->translate = array(
				'title' => __( "Happy Client Says", 'seoengine-core' ),
			);
			parent::__construct();
		}

		public function load_scripts(){
			wp_enqueue_style( 'owl-carousel' );
			wp_enqueue_style( 'owl-theme-default' );
			wp_enqueue_script( 'owl-carousel' );
		}

		public function fields(){
			$terms = get_terms( array('taxonomy' => 'seo_testimonial_category') );
			$category_dropdown = array( __( 'All Categories', 'seoengine-core' ) => '0' );
			foreach ( $terms as $category ) {
				$category_dropdown[$category->name] = $category->term_id;
			}

			$fields = array(
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Title", 'seoengine-core' ),
					"param_name" => "title",
					"value" => $this->translate['title'],
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Total number testimonials", 'seoengine-core' ),
					"param_name" => "number",
					"value" => -1,
					'description' => __( 'Write -1 to show all', 'seoengine-core' ),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Categories", 'seoengine-core' ),
					"param_name" => "cat",
					'value' => $category_dropdown,
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Order By", 'seoengine-core' ),
					"param_name" => "orderby",
					"value" => array(
						__( 'Date (Recents comes first)', 'seoengine-core' )  => 'date',
						__( 'Title', 'seoengine-core' ) => 'title',
						__( 'Custom Order (Available via Order field inside Page Attributes box)', 'seoengine-core' ) => 'menu_order',
					),
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Text Color", 'seoengine-core' ),
					"param_name" => "color",
					'value' => "#222",
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Thumbnail", 'seoengine-core' ),
					"param_name" => "thumb",
					"value" => array( 
						'Disabled' => 'false',
						'Enabled'  => 'true',
					),
				),
				// Slider options
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Navigation Arrow", 'seoengine-core' ),
					"param_name" => "slider_nav",
					"value" => array( 
						__( 'Enabled', 'seoengine-core' )  => 'true',
						__( 'Disabled', 'seoengine-core' ) => 'false',
						),
					"description" => __( "Enable or disable navigation arrow. Default: Enable", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
					),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Navigation Dots", 'seoengine-core' ),
					"param_name" => "slider_dots",
					"value" => array( 
						__( 'Disabled', 'seoengine-core' ) => 'false',
						__( 'Enabled', 'seoengine-core' )  => 'true',
						),
					"description" => __( "Enable or disable navigation dots. Default: Disable", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
					),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Autoplay", 'seoengine-core' ),
					"param_name" => "slider_autoplay",
					"value" => array( 
						__( 'Enabled', 'seoengine-core' )  => 'true',
						__( 'Disabled', 'seoengine-core' ) => 'false',
					),
					"description" => __( "Enable or disable autoplay. Default: Enable", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Stop on Hover", 'seoengine-core' ),
					"param_name" => "slider_stop_on_hover",
					"value" => array( 
						__( 'Enabled', 'seoengine-core' )  => 'true',
						__( 'Disabled', 'seoengine-core' ) => 'false',
					),
					'dependency' => array(
						'element' => 'slider_autoplay',
						'value'   => array( 'true' ),
					),
					"description" => __( "Stop autoplay on mouse hover. Default: Enable", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Autoplay Interval", 'seoengine-core' ),
					"param_name" => "slider_interval",
					"value" => array( 
						__( '5 Seconds', 'seoengine-core' ) => '5000',
						__( '4 Seconds', 'seoengine-core' ) => '4000',
						__( '3 Seconds', 'seoengine-core' ) => '3000',
						__( '2 Seconds', 'seoengine-core' ) => '4000',
						__( '1 Second', 'seoengine-core' )  => '1000',
					),
					'dependency' => array(
						'element' => 'slider_autoplay',
						'value'   => array( 'true' ),
					),
					"description" => __( "Set any value for example 5 seconds to play it in every 5 seconds. Default: 5 Seconds", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Autoplay Slide Speed", 'seoengine-core' ),
					"param_name" => "slider_autoplay_speed",
					"value" => 200,
					'dependency' => array(
						'element' => 'slider_autoplay',
						'value'   => array( 'true' ),
					),
					"description" => __( "Slide speed in milliseconds. Default: 200", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
				),	
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Loop", 'seoengine-core' ),
					"param_name" => "slider_loop",
					"value" => array( 
						__( 'Enabled', 'seoengine-core' )  => 'true',
						__( 'Disabled', 'seoengine-core' ) => 'false',
					),
					"description" => __( "Loop to first item. Default: Enable", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
				),
			);
			return $fields;
		}

		public function shortcode( $atts, $content = '' ){
			extract( shortcode_atts( array(
				'title'   => $this->translate['title'],
				'number'  => '-1',
				'cat'     => '',
				'orderby' => 'date',
				'color'   => '#222',
				'thumb'   => 'false',
				// slider
				'slider_nav'            => 'true',
				'slider_dots'           => 'false',
				'slider_autoplay'       => 'true',
				'slider_stop_on_hover'  => 'true',
				'slider_interval'       => '5000',
				'slider_autoplay_speed' => '200',
				'slider_loop'           => 'true',
				), $atts ) );


			// validation
			$number  = intval( $number );

			$owl_data = array( 
				'nav'                => ( $slider_nav === 'true' ) ? true : false,
				'navText'            => array( "<i class='fa fa-angle-left'></i>", "<i class='fa fa-angle-right'></i>" ),
				'dots'               => ( $slider_dots === 'true' ) ? true : false,
				'autoplay'           => ( $slider_autoplay === 'true' ) ? true: false,
				'autoplayTimeout'    => $slider_interval,
				'autoplaySpeed'      => $slider_autoplay_speed,
				'autoplayHoverPause' => ( $slider_stop_on_hover === 'true' ) ? true: false,
				'loop'               => ( $slider_loop === 'true' ) ? true: false,
				'responsive'         => array(
					'0'    => array( 'items' => 1 )
				)
			);

			$owl_data = json_encode( $owl_data );
			$this->load_scripts();

			$template = 'testimonial';

			return $this->template( $template, get_defined_vars() );
		}
	}
}

new RDTheme_VC_Testimonial;