<?php
if ( !class_exists( 'RDTheme_VC_Posts' ) ) {

	class RDTheme_VC_Posts extends RDTheme_VC_Modules {

		public function __construct(){
			$this->name = __( "SEOEngine: Posts", 'seoengine-core' );
			$this->base = 'seoengine-vc-posts';
			$this->translate = array(
				'btntxt'   => __( "View All", 'seoengine-core' ),
			);
			parent::__construct();
		}

		public function fields(){
			$categories = get_categories();
			$category_dropdown = array( 'All Categories' => '0' );

			foreach ( $categories as $category ) {
				$category_dropdown[$category->name] = $category->term_id;
			}

			$posts = get_posts( array( 'posts_per_page' => -1, 'orderby' => 'title','order' => 'ASC','post_status' => 'publish','suppress_filters' => false ) );
			$posts_dropdown = array();
			foreach ( $posts as $post ) {
				$posts_dropdown[$post->post_title] = $post->ID;
			}

			$fields = array(
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Style", 'seoengine-core' ),
					"param_name" => "style",
					"value" => array( 
						__( 'Style 1', 'seoengine-core' ) => 'style1',
						__( 'Style 2', 'seoengine-core' ) => 'style2',
						__( 'Style 3', 'seoengine-core' ) => 'style3',
					),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Which posts to display?", 'seoengine-core' ),
					"param_name" => "display",
					'value' => array( 
						__( 'Recent Posts', 'seoengine-core' )  => 'recent',
						__( 'Custom Select', 'seoengine-core' ) => 'custom',
					),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Categories", 'seoengine-core' ),
					"param_name" => "cat",
					'value' => $category_dropdown,
					'dependency' => array(
						'element' => 'display',
						'value' => array( 'recent' ),
					),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "1st Post", 'seoengine-core' ),
					"param_name" => "item1",
					'value' => $posts_dropdown,
					'dependency' => array(
						'element' => 'display',
						'value' => array( 'custom' ),
					),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "2nd Post", 'seoengine-core' ),
					"param_name" => "item2",
					'value' => $posts_dropdown,
					'dependency' => array(
						'element' => 'display',
						'value' => array( 'custom' ),
					),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "3rd Post", 'seoengine-core' ),
					"param_name" => "item3",
					'value' => $posts_dropdown,
					'description' => __( "3rd Post doesn't work for Style 1", 'seoengine-core' ),
					'dependency' => array(
						'element' => 'display',
						'value' => array( 'custom' ),
					),
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Background Color", 'seoengine-core' ),
					"param_name" => "bgcolor",
					'value' => "#F8F8F8",
					'dependency' => array(
						'element' => 'style',
						'value' => array( 'style1', 'style2' ),
					),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Button", 'seoengine-core' ),
					"param_name" => "btn",
					"value" => array(
						__( 'Enabled', 'seoengine-core' )  => 'true',
						__( 'Disabled', 'seoengine-core' ) => 'false',
					),
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Button Text", 'seoengine-core' ),
					"param_name" => "btntxt",
					'dependency' => array(
						'element' => 'btn',
						'value' => array( 'true' ),
					),
					"value" => $this->translate['btntxt'],
				),
			);
			return $fields;
		}

		public function shortcode( $atts, $content = '' ){
			extract( shortcode_atts( array(
				'style'   => 'style1',
				'display' => 'recent',
				'cat'     => '',
				'item1'   => '',
				'item2'   => '',
				'item3'   => '',
				'bgcolor' => '#F8F8F8',
				'btn'     => 'true',
				'btntxt'  => $this->translate['btntxt'],
				), $atts ) );

			// validation
			$cat   = empty( $cat ) ? '' : (int) $cat;
			$item1 = intval( $item1 );
			$item2 = intval( $item2 );
			$item3 = intval( $item3 );

			switch ( $style ) {
				case 'style2':
				$template = 'posts-2';
				break;
				case 'style3':
				$template = 'posts-3';
				break;	
				default:
				$template = 'posts-1';
				break;
			}			

			return $this->template( $template, get_defined_vars() );
		}
	}
}

new RDTheme_VC_Posts;