<?php
if ( !class_exists( 'RT_Posts' ) ) {
	return;
}
$post_types = array(
	'seo_case'     => array(
		'title'        => __( 'Case Study', 'seoengine-core' ),
		'plural_title' => __( 'Case Studies', 'seoengine-core' ),
		'menu_icon'    => 'dashicons-book',
		'rewrite'      => RDTheme::$options['case_slug'],
		'supports'     => array( 'title', 'thumbnail', 'editor', 'page-attributes' )
	),
	'seo_team'     => array(
		'title'        => __( 'Team Member', 'seoengine-core' ),
		'plural_title' => __( 'Team Members', 'seoengine-core' ),
		'menu_icon'    => 'dashicons-businessman',
		'labels_override'     => array(
			'menu_name'  => 'Team',
		),
		'rewrite'      => RDTheme::$options['team_slug'],
		'supports'     => array( 'title', 'thumbnail', 'editor', 'page-attributes' )
	),
	'seo_portfolio'     => array(
		'title'        => __( 'Portfolio', 'seoengine-core' ),
		'plural_title' => __( 'Portfolio', 'seoengine-core' ),
		'menu_icon'    => 'dashicons-portfolio',
		'rewrite'      => RDTheme::$options['portfolio_slug'],
		'supports'     => array( 'title', 'thumbnail', 'editor', 'page-attributes' )
	),
	'seo_testimonial'     => array(
		'title'        => __( 'Testimonial', 'seoengine-core' ),
		'plural_title' => __( 'Testimonials', 'seoengine-core' ),
		'menu_icon'    => 'dashicons-awards',
		'rewrite'      => false,
		'supports'     => array( 'title', 'thumbnail', 'editor', 'page-attributes' )
	),
);

$taxonomies = array(
	'seo_case_category' => array(
		'title'        => __( 'Case Study Category', 'seoengine-core' ),
		'plural_title' => __( 'Case Study Categories', 'seoengine-core' ),
		'post_types'   => 'seo_case',
	),
	'seo_portfolio_category' => array(
		'title'        => __( 'Portfolio Category', 'seoengine-core' ),
		'plural_title' => __( 'Portfolio Categories', 'seoengine-core' ),
		'post_types'   => 'seo_portfolio',
	),
	'seo_team_category' => array(
		'title'        => __( 'Team Category', 'seoengine-core' ),
		'plural_title' => __( 'Team Categories', 'seoengine-core' ),
		'post_types'   => 'seo_team',
	),
	'seo_testimonial_category' => array(
		'title'        => __( 'Testimonial Category', 'seoengine-core' ),
		'plural_title' => __( 'Testimonial Categories', 'seoengine-core' ),
		'post_types'   => 'seo_testimonial',
	),
);

$Posts = RT_Posts::getInstance();
$Posts->add_post_types( $post_types );
$Posts->add_taxonomies( $taxonomies );