<?php
global $KcSeoWPSchema;
$settings = get_option($KcSeoWPSchema->options['main_settings']);
$pt = !empty($settings['post-type']) ? $settings['post-type'] : array('post', 'page');
?>
<div class="wrap">
    <div id="upf-icon-edit-pages" class="icon32 icon32-posts-page"><br/></div>
    <h2><?php _e('Schema Settings', "wp-seo-structured-data-schema-pro"); ?></h2>
    <form id="kcseo-main-settings">

        <table width="40%" cellpadding="10" class="form-table">
            <tr class="default">
                <th><?php _e("Business / Org Schema", "wp-seo-structured-data-schema-pro") ?></th>
                <td align="left" scope="row">
                    <?php $dd = !empty($settings['site_schema']) ? $settings['site_schema'] : 'home_page'; ?>
                    <input type="radio" <?php echo($dd == 'home_page' ? 'checked' : null); ?> name="site_schema"
                           value="home_page" id="site_schema_home"><label for="site_schema_home"><?php _e("Home page
                        only", "wp-seo-structured-data-schema-pro") ?></label><br>
                    <input type="radio" <?php echo($dd == 'all' ? 'checked' : null); ?> name="site_schema" value="all"
                           id="site_schema_all"><label for="site_schema_all"><?php _e("Sitewide (Apply General Settings schema
                        sitewide)", "wp-seo-structured-data-schema-pro") ?></label><br>
                    <input type="radio" <?php echo($dd == 'off' ? 'checked' : null); ?> name="site_schema" value="off"
                           id="site_schema_off"><label
                            for="site_schema_off"><?php _e("Turn off (Turn off global schema)", "wp-seo-structured-data-schema-pro") ?></label>
                </td>
            </tr>
            <tr class="default">
                <th><?php _e("Post Type", "wp-seo-structured-data-schema-pro") ?></th>
                <td align="left" scope="row">
                    <?php
                    $postTypes = $KcSeoWPSchema->get_post_type_list();
                    foreach ($postTypes as $key => $value) {
                        $checked = (in_array($key, $pt) ? "checked" : null);
                        echo "<label for='pt-{$key}'><input id='pt-{$key}' {$checked} type='checkbox' name='post-type[]' value='{$key}' /> {$value}</label><br>";
                    }
                    ?>
                </td>
            </tr>
            <tr class="default">
                <th style="font-size: 18px; padding: 30px 0 5px;"><?php _e("Site Navigation Element Schema", "wp-seo-structured-data-schema-pro") ?></th>
            </tr>
            <tr class="default">
                <th><?php _e("Publisher Name", "wp-seo-structured-data-schema-pro") ?></th>
                <td align="left" scope="row">
                    <select name="site_nav">
                        <option value=""><?php _e("Select one menu", "wp-seo-structure-data-schema-pro") ?></option>
                        <?php
                        $menus = get_terms('nav_menu');
                        if (!empty($menus)) {
                            foreach ($menus as $menu) {
                                $slt = (!empty($settings['site_nav']) && $settings['site_nav'] == $menu->term_id) ? " selected" : null;
                                echo "<option value='{$menu->term_id}'{$slt}>{$menu->name}</option>";
                            }
                        }
                        ?>
                    </select>
                    <p class="description"><?php _e("Please deselect the navigation menu if you want to deactivate site navigation
                        schema.", "wp-seo-structured-data-schema-pro") ?></p>
                </td>
            </tr>
            <tr class="default">
                <th style="font-size: 18px; padding: 30px 0 5px;"><?php _e("Publisher Information", "wp-seo-structured-data-schema-pro") ?></th>
            </tr>
            <tr class="default">
                <th><?php _e("Publisher Name", "wp-seo-structured-data-schema-pro") ?></th>
                <td align="left" scope="row">
                    <input type="text" class="regular-text" name="publisher[name]"
                           value="<?php echo(!empty($settings['publisher']['name']) ? esc_attr($settings['publisher']['name']) : null); ?>"/>
                </td>
            </tr>
            <tr class="default">
                <th><?php _e("Publisher Logo", "wp-seo-structured-data-schema-pro") ?></th>
                <td align="left" scope="row">
                    <?php
                    $schemas = new KcSeoSchemaModel();
                    $data = array(
                        'id'    => 'publisher-logo',
                        'name'  => 'publisher[logo]',
                        'type'  => 'image',
                        'value' => (!empty($settings['publisher']['logo']) ? absint($settings['publisher']['logo']) : null),
                        'desc'  => __("Logos should have a wide aspect ratio, not a square icon.<br>Logos should be no wider than 600px, and no taller than 60px.<br>Always retain the original aspect ratio of the logo when resizing. Ideally, logos are exactly 60px tall with width <= 600px. If maintaining a height of 60px would cause the width to exceed 600px, downscale the logo to exactly 600px wide and reduce the height accordingly below 60px to maintain the original aspect ratio.<br>", "wp-seo-structured-data-schema-pro")
                    );
                    echo $schemas->get_field($data);
                    ?>
                </td>
            </tr>
            <tr class="default">
                <th style="font-size: 18px; padding: 30px 0 5px;"><?php _e("System Settings", "wp-seo-structured-data-schema-pro") ?></th>
            </tr>
            <tr class="default">
                <th><?php _e("Delete all data", "wp-seo-structured-data-schema-pro") ?></th>
                <td align="left" scope="row">
                    <?php $dd = !empty($settings['delete-data']) ? "checked" : null; ?>
                    <input type="checkbox" <?php echo $dd; ?> name="delete-data" value="1" id="delete-data"><label
                            for="delete-data"><?php _e("Enable", "wp-seo-structured-data-schema-pro") ?></label>
                    <p class="description"><?php _e("This will delete all schema created and applied by this plugin when plugin is
                        deleted.", "wp-seo-structured-data-schema-pro") ?></p>
                </td>
            </tr>
        </table>
        <p class="submit"><input type="submit" name="submit" id="tlpSaveButton" class="button button-primary"
                                 value="<?php _e('Save Changes', "wp-seo-structured-data-schema-pro"); ?>"></p>

        <?php wp_nonce_field($KcSeoWPSchema->nonceText(), '_kcseo_nonce'); ?>
    </form>
    <div id="response"></div>
</div>