<?php 
$args = array(
	'post_type'      => 'seo_testimonial',
	'posts_per_page' => $number,
	'orderby'        => $orderby,
);

if ( !empty( $cat ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => 'seo_testimonial_category',
			'field' => 'term_id',
			'terms' => $cat,
		)
	);
}

switch ( $orderby ) {
	case 'title':
	case 'menu_order':
	$args['order'] = 'ASC';
	break;
}

$query = new WP_Query( $args );
$title = trim( $title );
?>
<div class="rt-wid rt-owl-wid-testimonial owl-wrap rt-owl-nav-3">
	<?php if ( !empty( $title ) ): ?>
		<h2 class="rt-wid-title owl-custom-nav-title"><?php echo esc_html( $title );?></h2>		
	<?php endif; ?>
	<div class="owl-custom-nav">
		<div class="owl-prev"><i class="fa fa-angle-left"></i></div><div class="owl-next"><i class="fa fa-angle-right"></i></div>
	</div>
	<div class="clear"></div>
	<div class="owl-theme owl-carousel rt-owl-carousel" data-carousel-options="<?php echo esc_attr( $owl_data );?>">
		<?php if ( $query->have_posts() ) :?>
			<?php while ( $query->have_posts() ) : $query->the_post();?>
				<?php
				$id          = get_the_id();
				$designation = get_post_meta( $id, 'seo_tes_designation', true );
				$post        = get_post();
				$content     = $post->post_content;
				$content     = RDTheme_Helper::filter_content( $content );
				?>
				<div class="rt-vc-item">
					<div class="rt-vc-content"><?php echo $content;?></div>
					<div class="rt-vc-sep"></div>
					<div class="rt-vc-meta">
						<h3 class="rt-vc-title"><?php the_title();?></h3>
						<?php if ( !empty( $designation ) ): ?>
							<div class="rt-vc-designation"><?php echo esc_html( $designation );?></div>
						<?php endif; ?>						
					</div>
					<div class="clear"></div>
				</div>
			<?php endwhile;?>
		<?php endif;?>
		<?php wp_reset_query();?>
	</div>
</div>