<?php 
$args = array(
	'post_type'      => 'seo_testimonial',
	'posts_per_page' => $number,
	'orderby'        => $orderby,
);

if ( !empty( $cat ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => 'seo_testimonial_category',
			'field' => 'term_id',
			'terms' => $cat,
		)
	);
}

switch ( $orderby ) {
	case 'title':
	case 'menu_order':
	$args['order'] = 'ASC';
	break;
}

$query = new WP_Query( $args );
$slider_nav_class = ( $slider_nav == 'true' ) ? ' slider-nav-enabled' : '';
$title = trim( $title );
?>
<div class="row">
	<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
		<div style="color:<?php echo esc_attr( $color );?>;" class="owl-wrap rt-owl-nav-5 rt-owl-dot-4 rt-owl-testimonial-2<?php echo esc_attr( $slider_nav_class );?>" data-color="<?php echo esc_attr( $color );?>">
			<?php if ( !empty( $title ) ): ?>
				<h2 style="color:<?php echo esc_attr( $color );?>;" class="section-title"><?php echo esc_html( $title );?></h2>		
			<?php endif; ?>
			<div class="owl-theme owl-carousel rt-owl-carousel" data-carousel-options="<?php echo esc_attr( $owl_data );?>">
				<?php if ( $query->have_posts() ) :?>
					<?php while ( $query->have_posts() ) : $query->the_post();?>
						<?php
						$id          = get_the_id();
						$designation = get_post_meta( $id, 'seo_tes_designation', true );
						$post        = get_post();
						$content     = $post->post_content;
						$content     = RDTheme_Helper::filter_content( $content );
						?>
						<div class="rt-vc-item">
							<div class="rt-vc-content"><?php echo $content;?></div>
							<div class="rt-vc-sep"></div>
							<?php if ( $thumb == 'true' && has_post_thumbnail() ): ?>
								<div class="rt-vc-thumb"><?php the_post_thumbnail( 'thumbnail' );?></div>
							<?php endif; ?>
							<h3 style="color:<?php echo esc_attr( $color );?>;" class="rt-vc-title"><?php the_title();?></h3>
							<?php if ( !empty( $designation ) ): ?>
								<div class="rt-vc-designation"><?php echo esc_html( $designation );?></div>
							<?php endif; ?>
						</div>
					<?php endwhile;?>
				<?php endif;?>
				<?php wp_reset_query();?>
			</div>
		</div>
	</div>
</div>