<?php
$thumb_size = 'rdtheme-size6';
$args = array(
	'post_type'      => 'seo_team',
	'posts_per_page' => $slider_item_number,
	'orderby'        => $orderby,
);

if ( !empty( $cat ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => 'seo_team_category',
			'field' => 'term_id',
			'terms' => $cat,
		)
	);
}

switch ( $orderby ) {
	case 'title':
	case 'menu_order':
	$args['order'] = 'ASC';
	break;
}

$query = new WP_Query( $args );
$slider_nav_class = ( $slider_nav == 'true' ) ? ' slider-nav-enabled' : '';
?>
<div class="row">
	<div class="col-lg-12 col-md-12 col-sm-12">
		<div class="owl-wrap rt-owl-nav-4 rt-owl-dot-3 rt-owl-team-4<?php echo esc_attr( $slider_nav_class );?>">
			<div class="owl-theme owl-carousel rt-owl-carousel" data-carousel-options="<?php echo esc_attr( $owl_data );?>">
				<?php if ( $query->have_posts() ) :?>
					<?php while ( $query->have_posts() ) : $query->the_post();?>
						<?php
						$id = get_the_id();
						$designation = get_post_meta( $id, 'seo_team_designation', true );
						$socials = get_post_meta( $id, 'seo_team_socials', true );
						$content = RDTheme_Helper::get_current_post_content();
						$content = wp_trim_words( $content, $content_limit );
						?>
						<div class="rt-item">
							<div class="rt-thumb">
								<a href="<?php the_permalink();?>"><?php the_post_thumbnail( $thumb_size );?></a>
							</div>
							<div class="rt-content">
								<h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
								<?php if ( $designation_display ): ?>
									<div class="rt-designation"><?php echo esc_html( $designation );?></div>
								<?php endif; ?>
								<?php if ( $content ): ?>
									<div class="rt-description"><?php echo wp_kses_post( $content );?></div>
								<?php endif; ?>
								<?php if ( !empty( $socials ) ): ?>
									<ul>
										<?php foreach ( $socials as $key => $social ): ?>
											<?php if ( !empty( $social ) ): ?>
												<li><a style="background-color:<?php echo esc_attr( RDTheme::$team_social_fields[$key]['color']); ?>;" target="_blank" href="<?php echo esc_url( $social );?>"><i class="fa <?php echo esc_attr( RDTheme::$team_social_fields[$key]['icon'] );?>" aria-hidden="true"></i></a></li>
											<?php endif; ?>
										<?php endforeach; ?>
									</ul>
								<?php endif; ?>
							</div>
						</div>
					<?php endwhile;?>
				<?php endif;?>
				<?php wp_reset_query();?>
			</div>
		</div>
	</div>
</div>