<?php
$custom_class = vc_shortcode_custom_css_class( $css );

$style = "";
$style .= "background-color:{$bgcolor};";
if ( !empty( $maxwidth ) ) {
	$style .= "max-width:{$maxwidth}px;";
}
$price_html  = $price;
$price_html .= !empty( $unit ) ? "<span> /$unit</span>": '';
?>
<div class="<?php echo esc_attr( $custom_class );?>">
	<div class="rt-pricing-box-2" style="<?php echo esc_attr( $style );?>" data-bgcolor="<?php echo esc_attr( $bgcolor );?>" data-bghover="<?php echo esc_attr( $bghover );?>">
		<div class="rt-top">
			<div class="rt-title"><?php echo esc_html( $title );?></div>
			<div class="rt-price"><?php echo wp_kses_post( $price_html );?></div>
			<div class="rt-features">
				<?php foreach ( $features as $feature ): ?>
					<div><?php echo esc_html( $feature );?></div>
				<?php endforeach; ?>
			</div>	
		</div>
		<div class="rt-btn"><a href="<?php echo esc_url( $btnurl );?>"><?php echo esc_html( $btntext );?></a></div>
	</div>	
</div>