<?php
$thumb_size = 'rdtheme-size4';

$args = array(
	'posts_per_page'      => 3,
	'ignore_sticky_posts' => 1
);

if ( $display == 'recent' ) {
	$args['cat'] = $cat;
}

if ( $display == 'custom' ) {
	$args['post__in'] = array( $item1, $item2, $item3 );
	$args['orderby']  = 'post__in';
}

$query = new WP_Query( $args );
?>
<?php if ( $query->have_posts() ) :?>
	<div class="rt-vc-posts-2">
		<div class="row">
			<?php while ( $query->have_posts() ) : $query->the_post();?>
				<?php
				$blog_page = get_option( 'page_for_posts' );
				$blog_permalink = $blog_page ? get_permalink( $blog_page ) : home_url( '/' );
				$content = RDTheme_Helper::get_current_post_content();
				$content = wp_trim_words( $content, 12 );
				?>
				<div class="col-md-4 col-sm-12 col-xs-12">
					<div class="rt-item">
						<div class="rt-thumbnail-area">
							<a href="<?php the_permalink();?>" class="rt-thumbnail">
								<?php
								if ( has_post_thumbnail() ){
									the_post_thumbnail( $thumb_size );
								}
								else{
									echo !empty( RDTheme::$options['no_preview_image']['id'] ) ? wp_get_attachment_image( RDTheme::$options['no_preview_image']['id'], $thumb_size ) : '<img class="attachment-rdtheme-size4 size-rdtheme-size4 wp-post-image" src="'.RDTHEME_IMG_URL.'blog-noimage.jpg" alt="'.get_the_title().'">';
								}
								?>
							</a>
						</div>
						<div class="rt-content" style="background-color: <?php echo esc_attr( $bgcolor );?>">
							<h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
							<div class="rt-excerpt"><?php echo $content;?></div>
							<div class="rt-meta">
								<div class="rt-date"><i class="fa fa-calendar" aria-hidden="true"></i><?php the_time( 'd M, Y' );?></div>
								<div class="rt-comment"><i class="fa fa-comments-o" aria-hidden="true"></i><?php comments_number( '0', '1', '%' );?></div>
								<div class="clear"></div>
							</div>
						</div>					
					</div>
				</div>
			<?php endwhile;?>
		</div>
		<?php if ( $btn == 'true' ): ?>
			<div class="mt40"></div>
			<div class="view-btn"><a href="<?php echo esc_url( $blog_permalink ); ?>" class="rdtheme-button-1"><?php echo esc_html( $btntxt );?></a></div>			
		<?php endif; ?>

	</div>
<?php endif;?>
<?php wp_reset_query();?>