<?php
$thumb_size = 'rdtheme-size4';

$args = array(
	'posts_per_page'      => 2,
	'ignore_sticky_posts' => 1
);

if ( $display == 'recent' ) {
	$args['cat'] = $cat;
}

if ( $display == 'custom' ) {
	$args['post__in'] = array( $item1, $item2 );
	$args['orderby']  = 'post__in';
}

$query = new WP_Query( $args );
?>
<?php if ( $query->have_posts() ) :?>
	<div class="rt-vc-posts-1">
		<div class="row">
			<?php while ( $query->have_posts() ) : $query->the_post();?>
				<?php
				$rdtheme_time_html  = sprintf( '%s<span>%s</span>', get_the_time( 'd' ), get_the_time( 'M, Y' ) );
				$rdtheme_time_html  = apply_filters( 'rdtheme_single_time', $rdtheme_time_html );
				$blog_page = get_option( 'page_for_posts' );
				$blog_permalink = $blog_page ? get_permalink( $blog_page ) : home_url( '/' );
				?>
				<div class="col-sm-6 col-xs-12">
					<div class="rt-item">
						<div class="rt-header" style="background-color: <?php echo esc_attr( $bgcolor );?>">
							<div class="rt-thumbnail-area">
								<a href="<?php the_permalink();?>" class="rt-thumbnail">
									<?php
									if ( has_post_thumbnail() ){
										the_post_thumbnail( $thumb_size );
									}
									else{
										echo !empty( RDTheme::$options['no_preview_image']['id'] ) ? wp_get_attachment_image( RDTheme::$options['no_preview_image']['id'], $thumb_size ) : '<img class="attachment-rdtheme-size4 size-rdtheme-size4 wp-post-image" src="'.RDTHEME_IMG_URL.'blog-noimage.jpg" alt="'.get_the_title().'">';
									}
									?>
								</a>
								<div class="rt-date"><?php echo wp_kses_post( $rdtheme_time_html );?></div>
							</div>
							<div class="rt-title"><h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3></div>
						</div>					
					</div>
				</div>
			<?php endwhile;?>
		</div>
		<?php if ( $btn == 'true' ): ?>
			<div class="mt40"></div>
			<div class="view-btn"><a href="<?php echo esc_url( $blog_permalink ); ?>" class="rdtheme-button-1"><?php echo esc_html( $btntxt );?></a></div>			
		<?php endif; ?>

	</div>
<?php endif;?>
<?php wp_reset_query();?>