<?php
$thumb_size = 'rdtheme-size5';

$args = array(
	'post_type'      => 'seo_case',
	'posts_per_page' => $grid_item_number,
	'orderby'        => $orderby,
);

if ( !empty( $cat ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => 'seo_case_category',
			'field' => 'term_id',
			'terms' => $cat,
		)
	);
}

switch ( $orderby ) {
	case 'title':
	case 'menu_order':
	$args['order'] = 'ASC';
	break;
}

if ( $layout == 'grid' ) {
	if ( get_query_var('paged') ) {
		$paged = get_query_var('paged');
	}
	elseif ( get_query_var('page') ) {
		$paged = get_query_var('page');
	}
	else {
		$paged = 1;
	}

	$args['paged'] = $paged;
}

$query = new WP_Query( $args );
$col_class = "col-lg-$col_lg col-md-$col_md col-sm-$col_sm col-xs-$col_xs";

$meta_style = '';
if ( $layout == 'grid2' ) {
	$meta_style = "background-color:$bgcolor;";
}

// Pagination fix
global $wp_query;
$wp_query   = NULL;
$wp_query   = $query;
?>
<?php if ( have_posts() ) :?>
	<div class="rt-case-grid-1 layout-<?php echo esc_attr( $layout );?>">
		<div class="row auto-clear">
			<?php while ( have_posts() ) : the_post();?>
				<?php
				$thumbnail = false;
				if ( has_post_thumbnail() ){
					$thumbnail = get_the_post_thumbnail( null, $thumb_size );
				}
				elseif ( !empty( RDTheme::$options['no_preview_image']['id'] ) ) {
					$thumbnail = wp_get_attachment_image( RDTheme::$options['no_preview_image']['id'], $thumb_size );
				}
				elseif ( !empty( RDTheme::$options['no_preview_image']['url'] ) ) {
					$thumbnail = '<img class="attachment-rdtheme-size5 size-rdtheme-size5 wp-post-image" src="'.RDTHEME_IMG_URL.'noimage_390_260.jpg" alt="'.get_the_title().'">';
				}
				?>
				<div class="<?php echo esc_attr( $col_class );?>">
					<div class="rt-item">
						<?php if ( $thumbnail ): ?>
							<div class="rt-item-image">
								<a href="<?php the_permalink();?>"><?php echo $thumbnail;?></a>
							</div>
						<?php endif; ?>
						<div class="rt-item-meta" style="<?php echo esc_attr( $meta_style );?>">
							<h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
							<?php
							if ( $layout == 'grid' || $layout == 'grid1' ){
								$content = RDTheme_Helper::get_current_post_content();
								$content = wp_trim_words( $content, 17 );
								echo "<div>$content</div>";
							}
							?>
						</div>
					</div>
				</div>
			<?php endwhile;?>
			<?php if ( method_exists( 'RDTheme_Helper' , 'pagination' ) && $layout == 'grid' ): ?>
				<div class="col-sm-12 col-xs-12"><?php RDTheme_Helper::pagination();?></div>
			<?php endif; ?>
			<?php if ( $btn == 'true'  && ( $layout == 'grid1' || $layout == 'grid2' ) ): ?>
				<?php
				$bcn = get_option( 'bcn_options');
				if ( !empty( $bcn['apost_seo_case_root'] ) ) {
					$btn_url = get_permalink( $bcn['apost_seo_case_root'] );
				}
				else {
					$btn_url = get_post_type_archive_link( 'seo_case' );
				}
				?>
				<div class="col-sm-12 col-xs-12 mt30"><div class="view-btn"><a href="<?php echo esc_url( $btn_url ); ?>" class="rdtheme-button-2"><?php echo esc_html( $btntxt );?></a></div></div>
			<?php endif; ?>
		</div>
	</div>
<?php endif;?>
<?php wp_reset_query();?>