<?php
if ( !class_exists( 'RDTheme_VC_Title' ) ) {

	class RDTheme_VC_Title extends RDTheme_VC_Modules {

		public function __construct(){
			$this->name = __( "SEOEngine: Section Title", 'seoengine-core' );
			$this->base = 'seoengine-vc-title';
			$this->translate = array(
				'title' => __( "I AM TITLE", 'seoengine-core' ),
			);
			parent::__construct();
		}

		public function fields(){
			$fields = array(
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Title", 'seoengine-core' ),
					"param_name" => "title",
					"value" => $this->translate['title'],
				),
				array(
					"type" => "textarea",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Subtitle", 'seoengine-core' ),
					"param_name" => "subtitle",
					"value" => "Lorem ipsum dolor sit amet, consectetur adipisicing elit. Consequuntur, libero sed cum. Delectus suscipit tempore fugit, accusamus inventore, sunt quod ullam saepe consequuntur quasi illo odit",
				),
				array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => __( "Title color", "seoengine-core" ),
					"param_name" => "title_color",
					"value" => '#222222',
				),
				array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => __( "Subtitle color", "seoengine-core" ),
					"param_name" => "subtitle_color",
					"value" => '#707070',
				),
				array(
					'type' => 'css_editor',
					'heading' => __( 'Css', 'seoengine-core' ),
					'param_name' => 'css',
					'group' => __( 'Design options', 'seoengine-core' ),
					'edit_field_class' => 'vc-no-bg vc-no-border',
				),
			);
			return $fields;
		}

		public function shortcode( $atts, $content = '' ){
			extract( shortcode_atts( array(
				'title'           => $this->translate['title'],
				'subtitle'        => "Lorem ipsum dolor sit amet, consectetur adipisicing elit. Consequuntur, libero sed cum. Delectus suscipit tempore fugit, accusamus inventore, sunt quod ullam saepe consequuntur quasi illo odit",		
				'title_color'     => '#222222',
				'subtitle_color'  => '#707070',
				'css'             => '',
				), $atts ) );

			$template = 'title';

			return $this->template( $template, get_defined_vars() );
		}
	}
}

new RDTheme_VC_Title;