<?php
if ( !class_exists( 'RDTheme_VC_Pricing_Box' ) ) {

	class RDTheme_VC_Pricing_Box extends RDTheme_VC_Modules {

		public function __construct(){
			$this->name = __( "SEOEngine: Pricing Box", 'seoengine-core' );
			$this->base = 'seoengine-vc-pricing';
			$this->translate = array(
				'title'   => __( "STANDARD", 'seoengine-core' ),
				'price'   => __( "$59", 'seoengine-core' ),
				'unit'    => __( "month", 'seoengine-core' ),
				'btntext' => __( "Purchase", 'seoengine-core' ),
			);
			parent::__construct();
		}

		public function fields(){
			$fields = array(
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Background Color", 'seoengine-core' ),
					"param_name" => "bgcolor",
					'value' => "#4ad5c0",
					),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Background Hover Color", 'seoengine-core' ),
					"param_name" => "bghover",
					'value' => "#26c6da",
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Title", 'seoengine-core' ),
					"param_name" => "title",
					"value" => $this->translate['title'],
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Price", 'seoengine-core' ),
					"param_name" => "price",
					"value" => $this->translate['price'],
					"description" => __( "Including currency sign eg. $59", 'seoengine-core' ),
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Unit Name", 'seoengine-core' ),
					"param_name" => "unit",
					"value" => $this->translate['unit'],
					"description" => __( "eg. month or year. Keep empty if you don't want to show unit", 'seoengine-core' ),
					),
				array(
					"type" => "textarea",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Features", 'seoengine-core' ),
					"param_name" => "features",
					"value" => "",
					"description" => __( "One line per feature. Put BLANK keyword if you want blank line. eg.<br/>Free Hand<br/>5 Analytics Campaigns<br/>BLANK", 'seoengine-core' ),
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Button Text", 'seoengine-core' ),
					"param_name" => "btntext",
					"value" => $this->translate['btntext'],
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Button URL", 'seoengine-core' ),
					"param_name" => "btnurl",
					"value" => "",
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Maximum width", 'seoengine-core' ),
					"param_name" => "maxwidth",
					"value" => "",
					"description" => __( "Maximum width in px. Keep empty if you want full width. eg. 300", 'seoengine-core' ),
					),
				array(
					'type' => 'css_editor',
					'heading' => __( 'Css', 'seoengine-core' ),
					'param_name' => 'css',
					'group' => __( 'Design options', 'seoengine-core' ),
					),
				);
			return $fields;
		}

		private function validate( $str ){
			$str = trim( $str );
			// replace BLANK keyword
			if ( strtolower( $str ) == 'blank'  ) {
				return '&nbsp;';
			}
			return $str;
		}

		public function shortcode( $atts, $content = '' ){
			extract( shortcode_atts( array(
				'bgcolor'  => '#4ad5c0',
				'bghover'  => '#26c6da',
				'title'    => $this->translate['title'],
				'price'    => $this->translate['price'],		
				'unit'     => $this->translate['unit'],
				'features' => '',
				'btntext'  => $this->translate['btntext'],
				'btnurl'   => '',
				'maxwidth' => '',
				'css'      => '',
				), $atts ) );

			$maxwidth = (int) $maxwidth;

			$features = strip_tags( $features ); // remove tags
			$features = preg_split( "/\R/", $features ); // string to array
			$features = array_map( array( $this, 'validate' ), $features ); // validate

			$template = 'pricing-box';

			return $this->template( $template, get_defined_vars() );
		}
	}
}

new RDTheme_VC_Pricing_Box;