<?php
if ( !class_exists( 'RDTheme_VC_Portfolio' ) ) {

	class RDTheme_VC_Portfolio extends RDTheme_VC_Modules {

		public function __construct(){
			$this->name = __( "SEOEngine: Portfolio", 'seoengine-core' );
			$this->base = 'gymedge-vc-portfolio';
			$this->translate = array(
				'title' => __( "OUR PORTFOLIO", 'seoengine-core' ),
				'all'   => __( "All", 'seoengine-core' ),
				'cols'   => array( 
					__( '1 col', 'seoengine-core' ) => '12',
					__( '2 col', 'seoengine-core' ) => '6',
					__( '3 col', 'seoengine-core' ) => '4',
					__( '4 col', 'seoengine-core' ) => '3',
					__( '6 col', 'seoengine-core' ) => '2',
				),
			);
			parent::__construct();
		}

		public function load_isotope_scripts(){
			wp_enqueue_script( 'isotope-pkgd' );
			wp_enqueue_script( 'seoengine-vc-portfolio' );
		}

		public function load_owl_scripts(){
			wp_enqueue_style( 'owl-carousel' );
			wp_enqueue_style( 'owl-theme-default' );
			wp_enqueue_script( 'owl-carousel' );
		}

		public function fields(){
			$terms = get_terms( array('taxonomy' => 'seo_portfolio_category') );
			$category_dropdown = array( __( 'All Categories', 'seoengine-core' ) => '0' );
			foreach ( $terms as $category ) {
				$category_dropdown[$category->name] = $category->term_id;
			}

			$fields = array(
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Layout", 'seoengine-core' ),
					"param_name" => "layout",
					"value" => array( 
						__( 'Isotope', 'seoengine-core' ) => 'isotope',
						__( 'Slider', 'seoengine-core' )  => 'slider',
					),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Categories", 'seoengine-core' ),
					"param_name" => "cat",
					'value' => $category_dropdown,
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'slider' ),
					),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Order By", 'seoengine-core' ),
					"param_name" => "orderby",
					"value" => array(
						__( 'Date (Recents comes first)', 'seoengine-core' )  => 'date',
						__( 'Title', 'seoengine-core' ) => 'title',
						__( 'Custom Order (Available via Order field inside Page Attributes box)', 'seoengine-core' ) => 'menu_order',
					),
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'slider' ),
					),
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Total number of items", 'seoengine-core' ),
					"param_name" => "slider_item_number",
					"value" => 5,
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'slider' ),
					),
					'description' => __( 'Write -1 to show all', 'seoengine-core' ),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Title Visibility", 'seoengine-core' ),
					"param_name" => "showtitle",
					"value" => array( 
						__( 'Hidden', 'seoengine-core' )  => 'hidden',
						__( 'Visible', 'seoengine-core' ) => 'visible',
					),
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Title", 'seoengine-core' ),
					"param_name" => "title",
					"value" => $this->translate['title'],
					'dependency' => array(
						'element' => 'showtitle',
						'value'   => array( 'visible' ),
					),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Item Info Visibility ", 'seoengine-core' ),
					"param_name" => "showinfo",
					"value" => array( 
						__( 'Visible on Mouseover', 'seoengine-core' )  => 'mouseover',
						__( 'Visible Always', 'seoengine-core' )        => 'always',
					),
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'isotope' ),
					),
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "All items name", 'seoengine-core' ),
					"param_name" => "all",
					'value' => $this->translate['all'],
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'isotope' ),
					),
				),
				// Responsive Columns
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Number of columns ( Desktops > 1199px )", 'seoengine-core' ),
					"param_name" => "col_lg",
					"value" => $this->translate['cols'],
					"std" => "6",
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'slider', 'grid', 'grid1', 'grid2' ),
					),
					"group" => __( "Responsive Columns", 'seoengine-core' ),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Number of columns ( Desktops > 991px )", 'seoengine-core' ),
					"param_name" => "col_md",
					"value" => $this->translate['cols'],
					"std" => "6",
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'slider' ),
					),
					"group" => __( "Responsive Columns", 'seoengine-core' ),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Number of columns ( Tablets > 767px )", 'seoengine-core' ),
					"param_name" => "col_sm",
					"value" => $this->translate['cols'],
					"std" => "6",
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'slider' ),
					),
					"group" => __( "Responsive Columns", 'seoengine-core' ),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Number of columns ( Phones < 768px )", 'seoengine-core' ),
					"param_name" => "col_xs",
					"value" => $this->translate['cols'],
					"std" => "6",
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'slider' ),
					),
					"group" => __( "Responsive Columns", 'seoengine-core' ),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Number of columns ( Small Phones < 480px )", 'seoengine-core' ),
					"param_name" => "col_mobile",
					"value" => $this->translate['cols'],
					"std" => "12",
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'slider' ),
					),
					"group" => __( "Responsive Columns", 'seoengine-core' ),
				),
				// Slider options
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Navigation Dots", 'seoengine-core' ),
					"param_name" => "slider_dots",
					"value" => array( 
						__( 'Disabled', 'seoengine-core' ) => 'false',
						__( 'Enabled', 'seoengine-core' )  => 'true',
					),
					"description" => __( "Enable or disable navigation dots. Default: Disable", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Autoplay", 'seoengine-core' ),
					"param_name" => "slider_autoplay",
					"value" => array( 
						__( 'Enabled', 'seoengine-core' )  => 'true',
						__( 'Disabled', 'seoengine-core' ) => 'false',
					),
					"description" => __( "Enable or disable autoplay. Default: Enable", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Stop on Hover", 'seoengine-core' ),
					"param_name" => "slider_stop_on_hover",
					"value" => array( 
						__( 'Enabled', 'seoengine-core' )  => 'true',
						__( 'Disabled', 'seoengine-core' ) => 'false',
					),
					'dependency' => array(
						'element' => 'slider_autoplay',
						'value'   => array( 'true' ),
					),
					"description" => __( "Stop autoplay on mouse hover. Default: Enable", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Autoplay Interval", 'seoengine-core' ),
					"param_name" => "slider_interval",
					"value" => array( 
						__( '5 Seconds', 'seoengine-core' ) => '5000',
						__( '4 Seconds', 'seoengine-core' ) => '4000',
						__( '3 Seconds', 'seoengine-core' ) => '3000',
						__( '2 Seconds', 'seoengine-core' ) => '4000',
						__( '1 Second', 'seoengine-core' )  => '1000',
					),
					'dependency' => array(
						'element' => 'slider_autoplay',
						'value'   => array( 'true' ),
					),
					"description" => __( "Set any value for example 5 seconds to play it in every 5 seconds. Default: 5 Seconds", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Autoplay Slide Speed", 'seoengine-core' ),
					"param_name" => "slider_autoplay_speed",
					"value" => 200,
					'dependency' => array(
						'element' => 'slider_autoplay',
						'value'   => array( 'true' ),
					),
					"description" => __( "Slide speed in milliseconds. Default: 200", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
				),	
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Loop", 'seoengine-core' ),
					"param_name" => "slider_loop",
					"value" => array( 
						__( 'Enabled', 'seoengine-core' )  => 'true',
						__( 'Disabled', 'seoengine-core' ) => 'false',
					),
					"description" => __( "Loop to first item. Default: Enable", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
				),
			);
			return $fields;
		}

		public function shortcode( $atts, $content = '' ){
			extract( shortcode_atts( array(
				'layout'    			=> 'isotope',
				'cat'                   => '',
				'orderby'               => 'date',
				'slider_item_number'    => '5',
				'showtitle' 			=> 'hidden',
				'showinfo'  			=> 'mouseover',
				'title'     			=> $this->translate['title'],
				'all'       			=> $this->translate['all'],
				'col_lg'                => '6',
				'col_md'                => '6',
				'col_sm'                => '6',
				'col_xs'                => '6',
				'col_mobile'            => '12',
				// slider
				'slider_dots'           => 'false',
				'slider_autoplay'       => 'true',
				'slider_stop_on_hover'  => 'true',
				'slider_interval'       => '5000',
				'slider_autoplay_speed' => '200',
				'slider_loop'           => 'true',
				), $atts ) );

			// validation
			$cat                = empty( $cat ) ? '' : $cat;
			$slider_item_number = intval( $slider_item_number );
			$col_lg             = esc_attr( $col_lg );
			$col_md             = esc_attr( $col_md );
			$col_sm             = esc_attr( $col_sm );
			$col_xs             = esc_attr( $col_xs );
			$col_mobile         = esc_attr( $col_mobile );

			if ( $layout == 'slider' ) {
				$owl_data = array( 
					'nav'                => false,
					'dots'               => ( $slider_dots === 'true' ) ? true : false,
					'autoplay'           => ( $slider_autoplay === 'true' ) ? true: false,
					'autoplayTimeout'    => $slider_interval,
					'autoplaySpeed'      => $slider_autoplay_speed,
					'autoplayHoverPause' => ( $slider_stop_on_hover === 'true' ) ? true: false,
					'loop'               => ( $slider_loop === 'true' ) ? true: false,
					'margin'             => 30,
					'responsive'         => array(
						'0'    => array( 'items' => 12 / $col_mobile ),
						'480'  => array( 'items' => 12 / $col_xs ),
						'768'  => array( 'items' => 12 / $col_sm ),
						'992'  => array( 'items' => 12 / $col_md ),
						'1200' => array( 'items' => 12 / $col_lg ),
					)
				);
				$owl_data = json_encode( $owl_data );
				
				$this->load_owl_scripts();
				$template = 'portfolio-2';				
			}
			else {
				$this->load_isotope_scripts();
				$template = 'portfolio-1';
			}

			return $this->template( $template, get_defined_vars() );
		}
	}
}

new RDTheme_VC_Portfolio;