<?php
if ( !class_exists( 'RDTheme_VC_Info_Text' ) ) {

	class RDTheme_VC_Info_Text extends RDTheme_VC_Modules {

		public function __construct(){
			$this->name = __( "SEOEngine: Info Text", 'seoengine-core' );
			$this->base = 'seoengine-vc-infotext';
			$this->translate = array(
				'title' => __( "I am title", 'seoengine-core' ),
			);
			parent::__construct();
		}

		public function fields(){
			$fields = array(
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Layout", 'seoengine-core' ),
					"param_name" => "layout",
					'value' => array( 
						__( 'Layout 1', 'seoengine-core' ) => 'layout1',
						__( 'Layout 2', 'seoengine-core' ) => 'layout2',
						__( 'Layout 3', 'seoengine-core' ) => 'layout3',
						__( 'Layout 4', 'seoengine-core' ) => 'layout4',
						),
					),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Icon Type", 'seoengine-core' ),
					"param_name" => "icontype",
					'value' => array( 
						__( 'FlatIcon', 'seoengine-core' )     => 'flaticon',
						__( 'FontAwesome', 'seoengine-core' )  => 'fontawesome',
						__( 'Custom Image', 'seoengine-core' ) => 'image',
						),
					),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Flaticon', 'seoengine-core' ),
					'param_name' => 'icon_flat',
					"value" => 'flaticon-custom-target',
					'settings' => array(
						'emptyIcon' => false,
						'type' => 'flaticon',
						'iconsPerPage' => 160,
						),
					'dependency' => array(
						'element' => 'icontype',
						'value'   => array( 'flaticon' ),
						),
					),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'FontAwesome Icon', 'seoengine-core' ),
					'param_name' => 'icon_fa',
					"value" => 'fa fa-bar-chart',
					'settings' => array(
						'emptyIcon' => false,
						'iconsPerPage' => 160,
						),
					'dependency' => array(
						'element' => 'icontype',
						'value'   => array( 'fontawesome' ),
						),
					),
				array(
					"type" => "attach_image",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Upload icon image", 'seoengine-core' ),
					"param_name" => "image",
					'dependency' => array(
						'element' => 'icontype',
						'value'   => array( 'image' ),
						),
					),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Icon style", 'seoengine-core' ),
					"param_name" => "icon_style",
					'value' => array( 
						__( 'Rounded', 'seoengine-core' ) => 'rounded',
						__( 'Squire', 'seoengine-core' )  => 'squire',
					),
					),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Icon border", 'seoengine-core' ),
					"param_name" => "icon_border",
					"value" => array( 
						__( "Disabled", 'seoengine-core' ) => 'false',
						__( "Enabled", 'seoengine-core' )  => 'true',
					),
					'dependency' => array(
						'element' => 'layout',
						'value'   => array( 'layout3' ),
					),
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Icon color", 'seoengine-core' ),
					"param_name" => "color",
					"value" => "#48D4C2",
					'dependency' => array(
						'element' => 'icontype',
						'value'   => array( 'flaticon', 'fontawesome' ),
						),
					),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Mouseover color", 'seoengine-core' ),
					"param_name" => "hovercolor",
					"value" => "#26c6da",
					),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Background color", 'seoengine-core' ),
					"param_name" => "bgcolor",
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Icon size", 'seoengine-core' ),
					"param_name" => "size",
					'description' => __( 'Icon size in px eg. 30', 'seoengine-core' ),
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Icon padding", 'seoengine-core' ),
					"param_name" => "icon_padding",
					'description' => __( "Icon padding in px eg. 15. Doesn't work on custom image" , 'seoengine-core' ),
					'dependency' => array(
						'element' => 'layout',
						'value'   => array( 'layout1', 'layout3', 'layout4' ),
						),
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Title", 'seoengine-core' ),
					"param_name" => "title",
					"value" => $this->translate['title'],
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Title URL", 'seoengine-core' ),
					"param_name" => "url",
					'description' => __( "keep this field empty if you don't want the title linkable", 'seoengine-core' ),
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Title Font Size", 'seoengine-core' ),
					"param_name" => "title_size",
					'description' => __( 'Title font size in px. eg 20. If not defined, default h3 font size will be used', 'seoengine-core' ),
					),
				array(
					"type" => "textarea_html",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Content", 'seoengine-core' ),
					"param_name" => "content",
					"value" => __( 'I am Info Text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'seoengine-core' ),
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Content Font Size", 'seoengine-core' ),
					"param_name" => "content_size",
					'description' => __( 'Content font size in px eg. 15. If not defined, default body font size will be used', 'seoengine-core' ),
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Content Width", 'seoengine-core' ),
					"param_name" => "width",
					'description' => __( "Content maximum width in px eg 360. Keep this field empty if you want full width", 'seoengine-core' ),
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Spacing before title", 'seoengine-core' ),
					"param_name" => "spacing_top",
					"description" => __( "Spacing between icon and title in px eg. 25", 'seoengine-core' ),
					'dependency' => array(
						'element' => 'layout',
						'value'   => array( 'layout2', 'layout3', 'layout4' ),
						),
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Spacing after title", 'seoengine-core' ),
					"param_name" => "spacing_bottom",
					"description" => __( "Spacing between title and content in px eg. 12", 'seoengine-core' ),
					),
				array(
					'type' => 'css_editor',
					'heading' => __( 'Css', 'seoengine-core' ),
					'param_name' => 'css',
					'group' => __( 'Design options', 'seoengine-core' ),
					),
				);
			return $fields;
		}

		public function shortcode( $atts, $content = '' ){
			extract( shortcode_atts( array(
				'layout'         => 'layout1',
				'icontype'       => 'flaticon',
				'icon_flat'      => 'flaticon-custom-target',
				'icon_fa'        => 'fa fa-bar-chart',
				'color'          => '#48D4C2',
				'hovercolor'     => '#26c6da',
				'bgcolor'        => '',
				'image'          => '',
				'icon_style'     => 'rounded',
				'icon_border'    => 'false',
				'size'           => '',
				'icon_padding'   => '',
				'title'          => $this->translate['title'],
				'url'            => '',
				'title_size'     => '',
				'content_size'   => '',
				'width'          => '',
				'spacing_top'    => '',
				'spacing_bottom' => '',
				'css'            => '',
				), $atts ) );

			// validation
			$icon  = ( $icontype == 'flaticon' ) ? $icon_flat : $icon_fa;

			if ( $icontype == 'flaticon' ) {
				vc_icon_element_fonts_enqueue( $icon );
			}
			
			$template = 'info-text';

			return $this->template( $template, get_defined_vars() );
		}
	}
}

new RDTheme_VC_Info_Text;