<?php
if ( !class_exists( 'RDTheme_VC_Counter' ) ) {

	class RDTheme_VC_Counter extends RDTheme_VC_Modules {

		public function __construct(){
			$this->name = __( "SEOEngine: Counter", 'seoengine-core' );
			$this->base = 'seoengine-vc-counter';
			$this->translate = array(
				'title'   => __( "Customer Satisfaction", 'seoengine-core' ),
			);
			parent::__construct();
		}

		public function load_scripts(){
			wp_enqueue_script( 'waypoints' );
			wp_enqueue_script( 'counterup' );
		}

		public function fields(){
			$fields = array(
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Icon Type", 'seoengine-core' ),
					"param_name" => "icontype",
					'value' => array( 
						__( 'FlatIcon', 'seoengine-core' )     => 'flaticon',
						__( 'FontAwesome', 'seoengine-core' )  => 'fontawesome',
						__( 'Custom Image', 'seoengine-core' ) => 'image',
						),
					),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Flaticon', 'seoengine-core' ),
					'param_name' => 'icon_flat',
					"value" => 'flaticon-custom-handshake',
					'settings' => array(
						'emptyIcon' => false,
						'type' => 'flaticon',
						'iconsPerPage' => 160,
						),
					'dependency' => array(
						'element' => 'icontype',
						'value'   => array( 'flaticon' ),
						),
					),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'FontAwesome Icon', 'seoengine-core' ),
					'param_name' => 'icon_fa',
					"value" => 'fa fa-bar-chart',
					'settings' => array(
						'emptyIcon' => false,
						'iconsPerPage' => 160,
						),
					'dependency' => array(
						'element' => 'icontype',
						'value'   => array( 'fontawesome' ),
						),
					),
				array(
					"type" => "attach_image",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Upload icon image", 'seoengine-core' ),
					"param_name" => "image",
					'dependency' => array(
						'element' => 'icontype',
						'value'   => array( 'image' ),
						),
					),
				array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => __( "Icon color", "seoengine-core" ),
					"param_name" => "icon_color",
					"value" => '#26c6da',
					'dependency' => array(
						'element' => 'icontype',
						'value'   => array( 'flaticon', 'fontawesome' ),
						),
					),
				array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => __( "Counter color", "seoengine-core" ),
					"param_name" => "counter_color",
					"value" => '#d9d9d9',
					),
				array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => __( "Title color", "seoengine-core" ),
					"param_name" => "title_color",
					"value" => '#d9d9d9',
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Icon size", 'seoengine-core' ),
					"param_name" => "size",
					'description' => __( 'Icon size in px eg. 20', 'seoengine-core' ),
					'value' => '48',
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Counter Number", 'seoengine-core' ),
					"param_name" => "counter_number",
					"value" => '5000',
					'description' => __( 'Number to count eg. 5000', 'seoengine-core' ),
					),
                array(
                    "type" => "textfield",
                    "holder" => "div",
                    "class" => "",
                    "heading" => __( "Counter Speed", 'seoengine-core' ),
                    "param_name" => "counter_speed",
                    "value" => '5000',
                    'description' => __( 'The total duration of the count animation in milisecond eg. 5000', 'seoengine-core' ),
                    ),
                array(
                    "type" => "textfield",
                    "holder" => "div",
                    "class" => "",
                    "heading" => __( "Counter Steps", 'seoengine-core' ),
                    "param_name" => "counter_steps",
                    "value" => '10',
                    'description' => __( 'Counter steps eg. 10', 'seoengine-core' ),
                    ),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Title", 'seoengine-core' ),
					"param_name" => "title",
					"value" => $this->translate['title'],
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Spacing", 'seoengine-core' ),
					"param_name" => "spacing",
					'description' => __( 'Spacing between counter and title in px eg. 30', 'seoengine-core' ),
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Width", 'seoengine-core' ),
					"param_name" => "width",
					'description' => __( "Maximum width in px. Keep this field empty if you want full width", 'seoengine-core' ),
					),
				array(
					'type' => 'css_editor',
					'heading' => __( 'Css', 'seoengine-core' ),
					'param_name' => 'css',
					'group' => __( 'Design options', 'seoengine-core' ),
					'edit_field_class' => 'vc-no-bg vc-no-border',
					),
				);
			return $fields;
		}
		
		public function shortcode( $atts, $content = '' ){
			extract( shortcode_atts( array(
				'icontype'       => 'flaticon',
				'icon_flat'      => 'flaticon-custom-handshake',
				'icon_fa'        => 'fa fa-bar-chart',
				'image'	         => '',
				'icon_color'     => '#26c6da',
				'counter_color'	 => '#d9d9d9',
				'title_color'	 => '#d9d9d9',
				'icon_size'      => '48',
				'counter_number' => '5000',
                'counter_speed'  => '5000',
                'counter_steps'  => '10',
				'title'			 => $this->translate['title'],
				'spacing'        => '',
				'width'          => '',
				'css'            => '',
				), $atts ) );

			// validation
            $icon            = ( $icontype == 'flaticon' ) ? $icon_flat : $icon_fa;
			$icon_size   	 = intval( $icon_size );
            $counter_speed   = intval( $counter_speed );
            $counter_steps   = intval( $counter_steps );

			$number          = intval( $counter_number );
			$text            = explode( $number, $counter_number );
			$counter_number  = $number;
			$counter_text    = !empty( $text[1] ) ? $text[1] : '';

            if ( $icontype == 'flaticon' ) {
                vc_icon_element_fonts_enqueue( $icon );
            }
		
			$this->load_scripts();

			$template = 'counter';

			return $this->template( $template, get_defined_vars() );
		}
	}
}

new RDTheme_VC_Counter;