<?php
if ( !class_exists( 'RDTheme_VC_Contact' ) ) {

	class RDTheme_VC_Contact extends RDTheme_VC_Modules {

		public function __construct(){
			$this->name = __( "SEOEngine: Contact", 'seoengine-core' );
			$this->base = 'seoengine-vc-contact';
			$this->translate = array(
				'title' => __( "Information", 'seoengine-core' ),
			);
			parent::__construct();
		}

		public function fields(){
			$fields = array(
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Title", 'seoengine-core' ),
					"param_name" => "title",
					"value" => $this->translate['title'],
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Address", 'seoengine-core' ),
					"param_name" => "address",
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Phone", 'seoengine-core' ),
					"param_name" => "phone",
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Email", 'seoengine-core' ),
					"param_name" => "email",
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Fax", 'seoengine-core' ),
					"param_name" => "fax",
					),
				array(
					'type' => 'css_editor',
					'heading' => __( 'Css', 'seoengine-core' ),
					'param_name' => 'css',
					'group' => __( 'Design options', 'seoengine-core' ),
					),
			);
			return $fields;
		}

		public function shortcode( $atts, $content = '' ){
			extract( shortcode_atts( array(
				'title'   => $this->translate['title'],
				'address' => '',
				'phone'   => '',
				'email'   => '',
				'fax'     => '',
				'css'        => '',
				), $atts ) );

			$template = 'contact';

			return $this->template( $template, get_defined_vars() );
		}
	}
}

new RDTheme_VC_Contact;