<?php
if ( !class_exists( 'RDTheme_VC_Case_Study' ) ) {

	class RDTheme_VC_Case_Study extends RDTheme_VC_Modules {

		public function __construct(){
			$this->name = __( "SEOEngine: Case Studies", 'seoengine-core' );
			$this->base = 'seoengine-vc-case-study';
			$this->translate = array(
				'btntxt' => __( "View All", 'seoengine-core' ),
				'cols'   => array( 
					__( '1 col', 'seoengine-core' ) => '12',
					__( '2 col', 'seoengine-core' ) => '6',
					__( '3 col', 'seoengine-core' ) => '4',
					__( '4 col', 'seoengine-core' ) => '3',
					__( '6 col', 'seoengine-core' ) => '2',
				),
			);
			parent::__construct();
		}

		public function load_scripts(){
			wp_enqueue_style( 'owl-carousel' );
			wp_enqueue_style( 'owl-theme-default' );
			wp_enqueue_script( 'owl-carousel' );
		}

		public function fields(){
			$terms = get_terms( array('taxonomy' => 'seo_case_category') );
			$category_dropdown = array( __( 'All Categories', 'seoengine-core' ) => '0' );
			foreach ( $terms as $category ) {
				$category_dropdown[$category->name] = $category->term_id;
			}

			$posts = get_posts( array( 'posts_per_page' => -1, 'orderby' => 'title','order' => 'ASC','post_type' => 'seo_case','post_status' => 'publish', 'suppress_filters' => false ) );
			$posts_dropdown = array();
			foreach ( $posts as $post ) {
				$posts_dropdown[$post->post_title] = $post->ID;
			}

			$fields = array(
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Layout", 'seoengine-core' ),
					"param_name" => "layout",
					'value' => array( 
						__( "Slider", 'seoengine-core' ) => 'slider',
						__( "Box", 'seoengine-core' )    => 'box',
						__( "Grid Layout 1", 'seoengine-core' ) => 'grid1',
						__( "Grid Layout 2", 'seoengine-core' ) => 'grid2',
						__( "Grid Archive", 'seoengine-core' )  => 'grid',
						),
					),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Categories", 'seoengine-core' ),
					"param_name" => "cat",
					'value' => $category_dropdown,
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'slider', 'grid', 'grid1', 'grid2' ),
						),
					),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Order By", 'seoengine-core' ),
					"param_name" => "orderby",
					"value" => array(
						__( 'Date (Recents comes first)', 'seoengine-core' )  => 'date',
						__( 'Title', 'seoengine-core' ) => 'title',
						__( 'Custom Order (Available via Order field inside Page Attributes box)', 'seoengine-core' ) => 'menu_order',
					),
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'slider', 'grid', 'grid1', 'grid2' ),
					),
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Total number of items", 'seoengine-core' ),
					"param_name" => "slider_item_number",
					"value" => 5,
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'slider' ),
						),
					'description' => __( 'Write -1 to show all', 'seoengine-core' ),
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Items Per Page", 'seoengine-core' ),
					"param_name" => "grid_item_number",
					"value" => 9,
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'grid', 'grid1', 'grid2' ),
						),
					'description' => __( 'Write -1 to show all', 'seoengine-core' ),
					),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Title Background Color", 'seoengine-core' ),
					"param_name" => "bgcolor",
					'value' => "#F8F8F8",
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'grid2' ),
					),
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Button", 'seoengine-core' ),
					"param_name" => "btn",
					"value" => array(
						__( 'Disabled', 'seoengine-core' ) => 'false',
						__( 'Enabled', 'seoengine-core' )  => 'true',
						),
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'grid1', 'grid2' ),
						),
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Button Text", 'seoengine-core' ),
					"param_name" => "btntxt",
					'dependency' => array(
						'element' => 'btn',
						'value' => array( 'true' ),
						),
					"value" => $this->translate['btntxt'],
					),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "1st item", 'seoengine-core' ),
					"param_name" => "item1",
					'value' => $posts_dropdown,
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'box' ),
						),
					),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => __( "1st Item Title Color", 'seoengine-core' ),
					"param_name" => "h3color1",
					'value' => "#26c6da",
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'box' ),
						),
					),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "2nd item", 'seoengine-core' ),
					"param_name" => "item2",
					'value' => $posts_dropdown,
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'box' ),
						),
					),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => __( "2nd Item Title Color", 'seoengine-core' ),
					"param_name" => "h3color2",
					'value' => "#ffd740",
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'box' ),
						),
					),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "3rd item", 'seoengine-core' ),
					"param_name" => "item3",
					'value' => $posts_dropdown,
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'box' ),
						),
					),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => __( "3rd Item Title Color", 'seoengine-core' ),
					"param_name" => "h3color3",
					'value' => "#ff3d00",
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'box' ),
						),
					),
				// Responsive Columns
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Number of columns ( Desktops > 1199px )", 'seoengine-core' ),
					"param_name" => "col_lg",
					"value" => $this->translate['cols'],
					"std" => "4",
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'slider', 'grid', 'grid1', 'grid2' ),
						),
					"group" => __( "Responsive Columns", 'seoengine-core' ),
					),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Number of columns ( Desktops > 991px )", 'seoengine-core' ),
					"param_name" => "col_md",
					"value" => $this->translate['cols'],
					"std" => "4",
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'slider', 'grid', 'grid1', 'grid2' ),
						),
					"group" => __( "Responsive Columns", 'seoengine-core' ),
					),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Number of columns ( Tablets > 767px )", 'seoengine-core' ),
					"param_name" => "col_sm",
					"value" => $this->translate['cols'],
					"std" => "4",
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'slider', 'grid', 'grid1', 'grid2' ),
						),
					"group" => __( "Responsive Columns", 'seoengine-core' ),
					),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Number of columns ( Phones < 768px )", 'seoengine-core' ),
					"param_name" => "col_xs",
					"value" => $this->translate['cols'],
					"std" => "6",
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'slider', 'grid', 'grid1', 'grid2' ),
						),
					"group" => __( "Responsive Columns", 'seoengine-core' ),
					),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Number of columns ( Small Phones < 480px )", 'seoengine-core' ),
					"param_name" => "col_mobile",
					"value" => $this->translate['cols'],
					"std" => "12",
					'dependency' => array(
						'element' => 'layout',
						'value' => array( 'slider' ),
						),
					"group" => __( "Responsive Columns", 'seoengine-core' ),
					),
				// Slider options
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Navigation Arrow", 'seoengine-core' ),
					"param_name" => "slider_nav",
					"value" => array(
						__( 'Enabled', 'seoengine-core' )  => 'true',
						__( 'Disabled', 'seoengine-core' ) => 'false',
						),
					"description" => __( "Enable or disable navigation arrow. Default: Enable", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
					),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Navigation Dots", 'seoengine-core' ),
					"param_name" => "slider_dots",
					"value" => array( 
						__( 'Disabled', 'seoengine-core' ) => 'false',
						__( 'Enabled', 'seoengine-core' )  => 'true',
						),
					"description" => __( "Enable or disable navigation dots. Default: Disable", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
					),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Autoplay", 'seoengine-core' ),
					"param_name" => "slider_autoplay",
					"value" => array( 
						__( 'Enabled', 'seoengine-core' )  => 'true',
						__( 'Disabled', 'seoengine-core' ) => 'false',
						),
					"description" => __( "Enable or disable autoplay. Default: Enable", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
					),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Stop on Hover", 'seoengine-core' ),
					"param_name" => "slider_stop_on_hover",
					"value" => array( 
						__( 'Enabled', 'seoengine-core' )  => 'true',
						__( 'Disabled', 'seoengine-core' ) => 'false',
						),
					'dependency' => array(
						'element' => 'slider_autoplay',
						'value'   => array( 'true' ),
						),
					"description" => __( "Stop autoplay on mouse hover. Default: Enable", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
					),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Autoplay Interval", 'seoengine-core' ),
					"param_name" => "slider_interval",
					"value" => array( 
						__( '5 Seconds', 'seoengine-core' ) => '5000',
						__( '4 Seconds', 'seoengine-core' ) => '4000',
						__( '3 Seconds', 'seoengine-core' ) => '3000',
						__( '2 Seconds', 'seoengine-core' ) => '4000',
						__( '1 Second', 'seoengine-core' )  => '1000',
						),
					'dependency' => array(
						'element' => 'slider_autoplay',
						'value'   => array( 'true' ),
						),
					"description" => __( "Set any value for example 5 seconds to play it in every 5 seconds. Default: 5 Seconds", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
					),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Autoplay Slide Speed", 'seoengine-core' ),
					"param_name" => "slider_autoplay_speed",
					"value" => 200,
					'dependency' => array(
						'element' => 'slider_autoplay',
						'value'   => array( 'true' ),
						),
					"description" => __( "Slide speed in milliseconds. Default: 200", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
					),	
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Loop", 'seoengine-core' ),
					"param_name" => "slider_loop",
					"value" => array( 
						__( 'Enabled', 'seoengine-core' )  => 'true',
						__( 'Disabled', 'seoengine-core' ) => 'false',
						),
					"description" => __( "Loop to first item. Default: Enable", 'seoengine-core' ),
					"group" => __( "Slider Options", 'seoengine-core' ),
					),
				);

			return $fields;
		}

		public function shortcode( $atts, $content = '' ){
			extract( shortcode_atts( array(
				'layout'                => 'slider',
				'cat'                   => '',
				'orderby'               => 'date',
				'slider_item_number'    => '5',
				'grid_item_number'      => '9',
				'bgcolor'               => '#F8F8F8',
				'btn'                   => 'false',
				'btntxt'                => $this->translate['btntxt'],
				'col_lg'                => '4',
				'col_md'                => '4',
				'col_sm'                => '4',
				'col_xs'                => '6',
				'col_mobile'            => '12',
				'item1'                 => '',
				'item2'                 => '',
				'item3'                 => '',
				'h3color1'              => '#26c6da',
				'h3color2'              => '#ffd740',
				'h3color3'              => '#ff3d00',
				// slider
				'slider_nav'            => 'true',
				'slider_dots'           => 'false',
				'slider_autoplay'       => 'true',
				'slider_stop_on_hover'  => 'true',
				'slider_interval'       => '5000',
				'slider_autoplay_speed' => '200',
				'slider_loop'           => 'true',
				), $atts ) );


			// validation
			$cat                   = empty( $cat ) ? '' : $cat;
			$slider_item_number    = intval( $slider_item_number );
			$grid_item_number      = intval( $grid_item_number );

			$item1                 = intval( $item1 );
			$item2                 = intval( $item2 );
			$item3                 = intval( $item3 );
			$col_lg                = esc_attr( $col_lg );
			$col_md                = esc_attr( $col_md );
			$col_sm                = esc_attr( $col_sm );
			$col_xs                = esc_attr( $col_xs );
			$col_mobile            = esc_attr( $col_mobile );
			
			$owl_data = array( 
				'nav'                => ( $slider_nav === 'true' ) ? true : false,
				'navText'            => array( "<i class='fa fa-angle-left'></i>", "<i class='fa fa-angle-right'></i>" ),
				'dots'               => ( $slider_dots === 'true' ) ? true : false,
				'autoplay'           => ( $slider_autoplay === 'true' ) ? true: false,
				'autoplayTimeout'    => $slider_interval,
				'autoplaySpeed'      => $slider_autoplay_speed,
				'autoplayHoverPause' => ( $slider_stop_on_hover === 'true' ) ? true: false,
				'loop'               => ( $slider_loop === 'true' ) ? true: false,
				'margin'             => 30,
				'responsive'         => array(
					'0'    => array( 'items' => 12 / $col_mobile ),
					'480'  => array( 'items' => 12 / $col_xs ),
					'768'  => array( 'items' => 12 / $col_sm ),
					'992'  => array( 'items' => 12 / $col_md ),
					'1200' => array( 'items' => 12 / $col_lg ),
					)
				);

			switch ( $layout ) {
				case 'grid':
				case 'grid1':
				case 'grid2':
				$template = 'case-grid';
				break;
				case 'box':
				$template = 'case-box';
				break;
				default:
				$template = 'case-slider';
				$this->load_scripts();
				break;
			}
			
			$owl_data = json_encode( $owl_data );

			return $this->template( $template, get_defined_vars() );
		}
	}
}

new RDTheme_VC_Case_Study;