<?php
if ( !class_exists( 'RDTheme_VC_Button' ) ) {

	class RDTheme_VC_Button extends RDTheme_VC_Modules {

		public function __construct(){
			$this->name = __( "SEOEngine: Button", 'seoengine-core' );
			$this->base = 'seoengine-vc-button';
			$this->translate = array(
				'buttontext' => __( "Get It Now", 'seoengine-core' ),
			);
			parent::__construct();
		}

		public function fields(){
			$fields = array(
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Button Text", 'seoengine-core' ),
					"param_name" => "buttontext",
					"value" => $this->translate['buttontext'],
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Button URL", 'seoengine-core' ),
					"param_name" => "buttonurl",
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Button Alignment", 'seoengine-core' ),
					"param_name" => "btnalign",
					'value' => array( 
						__( 'Left', 'seoengine-core' )   => 'left',
						__( 'Center', 'seoengine-core' ) => 'center',
						__( 'Right', 'seoengine-core' )  => 'right',
						),
					),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Text Color", 'seoengine-core' ),
					"param_name" => "txtcolor",
					'value' => "#fff",
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Text Hover Color", 'seoengine-core' ),
					"param_name" => "txthovercolor",
					'value' => "#fff",
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Background Color", 'seoengine-core' ),
					"param_name" => "bgcolor",
					'value' => "#26c6da",
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Background Hover Color", 'seoengine-core' ),
					"param_name" => "bghovercolor",
					'value' => "#19abbd",
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => __( "Border Color", 'seoengine-core' ),
					"param_name" => "bdrcolor",
				),
				array(
					'type' => 'css_editor',
					'heading' => __( 'Css', 'seoengine-core' ),
					'param_name' => 'css',
					'group' => __( 'Design options', 'seoengine-core' ),
					'edit_field_class' => 'vc-no-bg vc-no-border',
				),
			);
			return $fields;
		}

		public function shortcode( $atts, $content = '' ){
			extract( shortcode_atts( array(
				'buttontext'    => $this->translate['buttontext'],
				'buttonurl'     => '',
				'btnalign'      => 'left',
				'txtcolor'      => '#fff',
				'txthovercolor' => '#fff',
				'bgcolor'       => '#26c6da',
				'bghovercolor'  => '#19abbd',
				'bdrcolor'      => '',
				'css'           => '',
				), $atts ) );

			$template = 'button';

			return $this->template( $template, get_defined_vars() );
		}
	}
}

new RDTheme_VC_Button;