<?php
/*
Plugin Name: SEOEngine Core
Plugin URI: http://radiustheme.com
Description: SEOEngine Core Plugin for SEOEngine Theme
Version: 1.11
Author: RadiusTheme
Author URI: http://radiustheme.com
*/

define( 'SEOENGINE_CORE_VERSION', ( WP_DEBUG ) ? time() : '1.11' );
define( 'SEOENGINE_CORE_BASE_URL', plugin_dir_url( __FILE__ ) );

// Text Domain
add_action( 'plugins_loaded', 'seoengine_core_load_textdomain' );
if ( !function_exists( 'seoengine_core_load_textdomain' ) ) {
	function seoengine_core_load_textdomain() {
		load_plugin_textdomain( 'seoengine-core' , false, dirname( plugin_basename( __FILE__ ) ) . '/languages' ); 
	}
}

// Post types
add_action( 'after_setup_theme', 'seoengine_core_post_types', 15 );
if ( !function_exists( 'seoengine_core_post_types' ) ) {
	function seoengine_core_post_types(){
		if ( !defined( 'SEOENGINE_VERSION' ) || ! defined( 'RT_FRAMEWORK_VERSION' ) ) {
			return;
		}
		require_once 'post-types.php';
		require_once 'post-meta.php';
	}
}

// Visual composer
add_action( 'after_setup_theme', 'seoengine_core_vc_modules', 20 );
if ( !function_exists( 'seoengine_core_vc_modules' ) ) {
	function seoengine_core_vc_modules(){
		if ( !defined( 'SEOENGINE_VERSION' ) || ! defined( 'WPB_VC_VERSION' ) ) {
			return;
		}

		require_once 'vc-flaticon/vc-flaticon.php';

		$modules = array( 'inc/abstruct', 'title', 'info-text', 'cta', 'button', 'counter', 'pricing-box', 'posts', 'case-study', 'team', 'portfolio', 'testimonial', 'contact', 'wid-menu', 'wid-testimonial' );
		$modules = apply_filters( 'seoengine_vc_addons_list', $modules );

		foreach ( $modules as $module ) {
			$template_name = "/vc-custom-addons/{$module}-class.php";
			if ( file_exists( STYLESHEETPATH . $template_name ) ) {
				$file = STYLESHEETPATH . $template_name;
			}
			elseif ( file_exists( TEMPLATEPATH . $template_name ) ) {
				$file = TEMPLATEPATH . $template_name;
			}
			else {
				$file = 'vc-modules/' . $module. '.php';
			}

			require_once $file;
		}
	}
}

// Demo Importer config
require_once 'demo-importer.php';