<?php
if ( !class_exists( 'RT_Postmeta' ) ) {
	return;
}

$Postmeta = RT_Postmeta::getInstance();

/*-------------------------------------
#. Page Settings
---------------------------------------*/
$nav_menus = wp_get_nav_menus( array( 'fields' => 'id=>name' ) );
$nav_menus = array( 'default' => __( 'Default', 'seoengine-core' ) ) + $nav_menus;

$Postmeta->add_meta_box( 'page_settings', __( 'Layout Settings', 'seoengine-core' ), array( 'page', 'post', 'seo_case' ), '', '', 'high', array(
	'fields' => array(
		'seoengine_layout' => array(
			'label' => __( 'Layout', 'seoengine-core' ),
			'type'  => 'select',
			'options' => array(
				'default'       => __( 'Default', 'seoengine-core' ),
				'full-width'    => __( 'Full Width', 'seoengine-core' ),
				'left-sidebar'  => __( 'Left Sidebar', 'seoengine-core' ),
				'right-sidebar' => __( 'Right Sidebar', 'seoengine-core' ),
				),
			'default'  => 'default',
			),
		'seoengine_page_menu' => array(
			'label' => __( 'Main Menu', 'seoengine-core' ),
			'type'  => 'select',
			'options' => $nav_menus,
			'default'  => 'default',
			),
		'seoengine_tr_header' => array(
			'label' => __( 'Transparent Header', 'seoengine-core' ),
			'type'  => 'select',
			'options' => array(
				'default' => __( 'Default', 'seoengine-core' ),
				'on'      => __( 'Enabled', 'seoengine-core' ),
				'off'     => __( 'Disabled', 'seoengine-core' ),
				),
			'default'  => 'default',
			),
		'seoengine_top_bar' => array(
			'label' => __( 'Top Bar', 'seoengine-core' ),
			'type'  => 'select',
			'options' => array(
				'default' => __( 'Default', 'seoengine-core' ),
				'on'      => __( 'Enabled', 'seoengine-core' ),
				'off'     => __( 'Disabled', 'seoengine-core' ),
				),
			'default'  => 'default',
			),
		'seoengine_top_bar_style' => array(
			'label' => __( 'Top Bar Layout', 'seoengine-core' ),
			'type'  => 'select',
			'options' => array(
				'default' => __( 'Default', 'seoengine-core' ),
				'1'       => __( 'Layout 1', 'seoengine-core' ),
				'2'       => __( 'Layout 2', 'seoengine-core' ),
				'3'       => __( 'Layout 3', 'seoengine-core' ),
				),
			'default'  => 'default',
			),
		'seoengine_header' => array(
			'label' => __( 'Header Layout', 'seoengine-core' ),
			'type'  => 'select',
			'options' => array(
				'default' => __( 'Default', 'seoengine-core' ),
				'1'       => __( 'Layout 1', 'seoengine-core' ),
				'2'       => __( 'Layout 2', 'seoengine-core' ),
				'3'       => __( 'Layout 3', 'seoengine-core' ),
				'4'       => __( 'Layout 4', 'seoengine-core' ),
				'5'       => __( 'Layout 5', 'seoengine-core' ),
				),
			'default'  => 'default',
			),
		'seoengine_top_padding' => array(
			'label' => __( 'Content Padding Top', 'seoengine-core' ),
			'type'  => 'select',
			'options' => array(
				'default' => __( 'Default', 'seoengine-core' ),
				'0px'     => '0px',
				'10px'    => '10px',
				'20px'    => '20px',
				'30px'    => '30px',
				'40px'    => '40px',
				'50px'    => '50px',
				'60px'    => '60px',
				'70px'    => '70px',
				'80px'    => '80px',
				'90px'    => '90px',
				'100px'   => '100px',
				),
			'default'  => 'default',
			),
		'seoengine_bottom_padding' => array(
			'label' => __( 'Content Padding Bottom', 'seoengine-core' ),
			'type'  => 'select',
			'options' => array(
				'default' => __( 'Default', 'seoengine-core' ),
				'0px'     => '0px',
				'10px'    => '10px',
				'20px'    => '20px',
				'30px'    => '30px',
				'40px'    => '40px',
				'50px'    => '50px',
				'60px'    => '60px',
				'70px'    => '70px',
				'80px'    => '80px',
				'90px'    => '90px',
				'100px'   => '100px',
				),
			'default'  => 'default',
			),
		'seoengine_banner' => array(
			'label' => __( 'Banner', 'seoengine-core' ),
			'type'  => 'select',
			'options' => array(
				'default' => __( 'Default', 'seoengine-core' ),
				'on'    => __( 'Enable', 'seoengine-core' ),
				'off'  => __( 'Disable', 'seoengine-core' ),
				),
			'default'  => 'default',
			),
		'seoengine_breadcrumb' => array(
			'label' => __( 'Breadcrumb', 'seoengine-core' ),
			'type'  => 'select',
			'options' => array(
				'default' => __( 'Default', 'seoengine-core' ),
				'on'    => __( 'Enable', 'seoengine-core' ),
				'off'  => __( 'Disable', 'seoengine-core' ),
				),
			'default'  => 'default',
			),
		'seoengine_banner_type' => array(
			'label' => __( 'Banner Background Type', 'seoengine-core' ),
			'type'  => 'select',
			'options' => array(
				'default' => __( 'Default', 'seoengine-core' ),
				'bgimg'    => __( 'Background Image', 'seoengine-core' ),
				'bgcolor'  => __( 'Background Color', 'seoengine-core' ),
				),
			'default'  => 'default',
			),
		'seoengine_banner_bgimg' => array(
			'label' => __( 'Banner Background Image', 'seoengine-core' ),
			'type'  => 'image',
			'desc'  => __( 'If not selected, default will be used', 'seoengine-core' ),
			),
		'seoengine_banner_bgcolor' => array(
			'label' => __( 'Banner Background Color', 'seoengine-core' ),
			'type'  => 'color_picker',
			'desc'  => __( 'If not selected, default will be used', 'seoengine-core' ),
			),
		),
	) );

/*-------------------------------------
#. Case Study
---------------------------------------*/
$args = array(
	'posts_per_page'   => -1,
	'exclude'          => !empty( $_GET['post'] ) ? $_GET['post'] : '',
	'orderby'          => 'title',
	'order'            => 'DESC',
	'post_type'        => 'seo_case',
	'suppress_filters' => false,
);
$cases = get_posts( $args );
$cases_array = array();
foreach ( $cases as $case ) {
	$cases_array[$case->ID] = $case->post_title;
}

$Postmeta->add_meta_box( 'case_study_settings', __( 'Case Study Settings', 'seoengine-core' ), array( 'seo_case' ), '', '', 'high', array(
	'fields' => array(
		'seoengine_rcase_display' => array(
			'label' => __( 'Display Related Case Studies', 'seoengine-core' ),
			'type'  => 'select',
			'options' => array(
				'disabled' => __( 'Disabled', 'seoengine-core' ),
				'enabled'  => __( 'Enabled', 'seoengine-core' ),
				),
			'default'  => 'disabled',
			),
		'seoengine_rcases' => array(
			'label' => __( 'Related Case Studies to include', 'seoengine-core' ),
			'type'  => 'multi_select',
			'options' => $cases_array,
			),
		),
	) );

/*-------------------------------------
#. Team
---------------------------------------*/
$team_socials = array(
	'facebook' => array(
		'label' => __( 'Facebook', 'seoengine-core' ),
		'type'  => 'text',
		'icon'  => 'fa-facebook',
		'color' => '#3b5998',
		),
	'twitter' => array(
		'label' => __( 'Twitter', 'seoengine-core' ),
		'type'  => 'text',
		'icon'  => 'fa-twitter',
		'color' => '#1da1f2',
		),
	'linkedin' => array(
		'label' => __( 'Linkedin', 'seoengine-core' ),
		'type'  => 'text',
		'icon'  => 'fa-linkedin',
		'color' => '#006fa6',
		),
	'gplus' => array(
		'label' => __( 'Google Plus', 'seoengine-core' ),
		'type'  => 'text',
		'icon'  => 'fa-google-plus',
		'color' => '#dd4f43',
		),
	'skype' => array(
		'label' => __( 'Skype', 'seoengine-core' ),
		'type'  => 'text',
		'icon'  => 'fa-skype',
		'color' => '#02B4EB',
		),
	'youtube' => array(
		'label' => __( 'Youtube', 'seoengine-core' ),
		'type'  => 'text',
		'icon'  => 'fa-youtube-play',
		'color' => '#DD2C28',
		),
	'pinterest' => array(
		'label' => __( 'Pinterest', 'seoengine-core' ),
		'type'  => 'text',
		'icon'  => 'fa-pinterest-p',
		'color' => '#CB1F27',
		),
	'instagram' => array(
		'label' => __( 'Instagram', 'seoengine-core' ),
		'type'  => 'text',
		'icon'  => 'fa-instagram',
		'color' => '#AA3DB2',
		),
	'github' => array(
		'label' => __( 'Github', 'seoengine-core' ),
		'type'  => 'text',
		'icon'  => 'fa-github',
		'color' => '#111',
		),
	'stackoverflow' => array(
		'label' => __( 'Stackoverflow', 'seoengine-core' ),
		'type'  => 'text',
		'icon'  => 'fa-stack-overflow',
		'color' => '#F48024',
		),
	);

$team_socials = apply_filters( 'team_socials', $team_socials );

RDTheme::$team_social_fields = $team_socials;

$Postmeta->add_meta_box( 'team_settings', __( 'Team Member Settings', 'seoengine-core' ), array( 'seo_team' ), '', '', 'high', array(
	'fields' => array(
		'seo_team_designation' => array(
			'label' => __( 'Designation', 'seoengine-core' ),
			'type'  => 'text',
			),
		'seo_team_socials_header' => array(
			'label' => __( 'Socials', 'seoengine-core' ),
			'type'  => 'header',
			'desc'  => __( 'Put your social links here', 'seoengine-core' ),
			),
		'seo_team_socials' => array(
			'type'  => 'group',
			'value'  => $team_socials
			),
		)
	) );

/*-------------------------------------
#. Portfolio
---------------------------------------*/
$Postmeta->add_meta_box( 'Portfolio_info', __( 'Portfolio Info', 'seoengine-core' ), array( 'seo_portfolio' ), '', '', 'high', array(
	'fields' => array(
		'seo_portfolio_header' => array(
			'label' => 'Custom Fields',
			'type'  => 'header',
			'desc'  => __( "Click on 'Add New Field' button to create new field", 'seoengine-core' ),
			),
		'seo_portfolio_fields' => array(
			'type'  => 'repeater',
			'button' => __( 'Add New Field', 'seoengine-core' ),
			'value'  => array(
				'portfolio_label' => array(
					'label' => __( 'Field Name', 'seoengine-core' ),
					'type'  => 'text',
				),
				'portfolio_value' => array(
					'label' => __( 'Field Value', 'seoengine-core' ),
					'type'  => 'textarea',
				),
			)
		),
	),
));

/*-------------------------------------
#. Testimonial
---------------------------------------*/
$Postmeta->add_meta_box( 'testimonial_info', __( 'Testimonial Info', 'seoengine-core' ), array( 'seo_testimonial' ), '', '', 'high', array(
	'fields' => array(
		'seo_tes_designation' => array(
			'label' => __( 'Designation', 'seoengine-core' ),
			'type'  => 'text',
			),
		)
	) );