<?php
add_action( 'plugins_loaded', 'seoengine_core_load_demo_importer', 15 );
function seoengine_core_load_demo_importer(){
	add_filter( 'plugin_action_links_rt-demo-importer/rt-demo-importer.php', 'seoengine_importer_add_action_links' );
	add_filter( 'rt_demo_installer_warning', 'seoengine_importer_warning' );
	add_filter( 'fw:ext:backups-demo:demos', 'seoengine_importer_backups_demos' );
	add_action( 'fw:ext:backups:tasks:success:id:demo-content-install', 'seoengine_importer_after_demo_install' );
	//add_filter( 'fw:ext:backups:add-restore-task:image-sizes-restore', '__return_false' ); // Enable it to skip image restore step
}

function seoengine_importer_warning( $links ) {
	$html  = '<div style="color:#f00;font-size:20px;line-height:1.3;font-weight:600;margin-bottom:40px;border-color: #f00;border-style: dashed;border-width: 1px 0;padding:10px 0;">';
	$html .= sprintf( __( 'Warning: All your old data will be lost if you install One Click demo data from here, so it is suitable only for a new website. For existing website please use XML data import method which is described in the documentation <a %s>here</a>', 'seoengine-core'), 'href="https://radiustheme.com/demo/wordpress/seoengine/docs/#demo" target="_blank" style="color:red;"' );
	$html .= '</div>';
	return $html;
}

function seoengine_importer_add_action_links( $links ) {
	$mylinks = array(
		'<a href="' . esc_url( admin_url( 'tools.php?page=fw-backups-demo-content' ) ) . '">'.__( 'Install Demo Contents', 'seoengine-core' ).'</a>',
	);
	return array_merge( $links, $mylinks );
}

function seoengine_importer_backups_demos( $demos ) {
	$demos_array = array(
		'demo1' => array(
			'title' => __( 'Home 1', 'seoengine-core' ),
			'screenshot' => plugins_url( 'screenshots/screenshot1.jpg', __FILE__ ),
			'preview_link' => 'http://radiustheme.com/demo/wordpress/seoengine/',
		),
		'demo2' => array(
			'title' => __( 'Home 2', 'seoengine-core' ),
			'screenshot' => plugins_url( 'screenshots/screenshot2.jpg', __FILE__ ),
			'preview_link' => 'http://radiustheme.com/demo/wordpress/seoengine/home-2/',
		),
		'demo3' => array(
			'title' => __( 'Home 3', 'seoengine-core' ),
			'screenshot' => plugins_url( 'screenshots/screenshot3.jpg', __FILE__ ),
			'preview_link' => 'http://radiustheme.com/demo/wordpress/seoengine/home-3/',
		),
		'demo4' => array(
			'title' => __( 'Home 4', 'seoengine-core' ),
			'screenshot' => plugins_url( 'screenshots/screenshot4.jpg', __FILE__ ),
			'preview_link' => 'http://radiustheme.com/demo/wordpress/seoengine/home-4/',
		),
		'demo5' => array(
			'title' => __( 'Home 5', 'seoengine-core' ),
			'screenshot' => plugins_url( 'screenshots/screenshot5.jpg', __FILE__ ),
			'preview_link' => 'http://radiustheme.com/demo/wordpress/seoengine/home-5/',
		),
		'demo6' => array(
			'title' => __( 'Home 6', 'seoengine-core' ),
			'screenshot' => plugins_url( 'screenshots/screenshot6.jpg', __FILE__ ),
			'preview_link' => 'http://radiustheme.com/demo/wordpress/seoengine/home-6/',
		),
		'demo7' => array(
			'title' => __( 'Home 1 Onepage', 'seoengine-core' ),
			'screenshot' => plugins_url( 'screenshots/screenshot7.jpg', __FILE__ ),
			'preview_link' => 'http://radiustheme.com/demo/wordpress/seoengine/home-1-onepage/',
		),
		'demo8' => array(
			'title' => __( 'Home 2 Onepage', 'seoengine-core' ),
			'screenshot' => plugins_url( 'screenshots/screenshot8.jpg', __FILE__ ),
			'preview_link' => 'http://radiustheme.com/demo/wordpress/seoengine/home-2-onepage/',
		),
		'demo9' => array(
			'title' => __( 'Home 3 Onepage', 'seoengine-core' ),
			'screenshot' => plugins_url( 'screenshots/screenshot9.jpg', __FILE__ ),
			'preview_link' => 'http://radiustheme.com/demo/wordpress/seoengine/home-3-onepage/',
		),
		'demo10' => array(
			'title' => __( 'Home 4 Onepage', 'seoengine-core' ),
			'screenshot' => plugins_url( 'screenshots/screenshot10.jpg', __FILE__ ),
			'preview_link' => 'http://radiustheme.com/demo/wordpress/seoengine/home-4-onepage/',
		),
		'demo11' => array(
			'title' => __( 'Home 5 Onepage', 'seoengine-core' ),
			'screenshot' => plugins_url( 'screenshots/screenshot11.jpg', __FILE__ ),
			'preview_link' => 'http://radiustheme.com/demo/wordpress/seoengine/home-5-onepage/',
		),
		'demo12' => array(
			'title' => __( 'Home 6 Onepage', 'seoengine-core' ),
			'screenshot' => plugins_url( 'screenshots/screenshot12.jpg', __FILE__ ),
			'preview_link' => 'http://radiustheme.com/demo/wordpress/seoengine/home-6-onepage/',
		),
	);

	$download_url = 'http://radiustheme.com/demo/wordpress/demo-content/seoengine/';

	foreach ($demos_array as $id => $data) {
		$demo = new FW_Ext_Backups_Demo($id, 'piecemeal', array(
			'url' => $download_url,
			'file_id' => $id,
		));
		$demo->set_title($data['title']);
		$demo->set_screenshot($data['screenshot']);
		$demo->set_preview_link($data['preview_link']);

		$demos[ $demo->get_id() ] = $demo;

		unset($demo);
	}

	return $demos;
}

// Run after demo install
function seoengine_importer_after_demo_install( $collection ){
	// Update front page id
	$demos = array(
		'demo1' => 31,
		'demo2' => 321,
		'demo3' => 392,
		'demo4' => 417,
		'demo5' => 536,
		'demo6' => 502,
		'demo7' => 698,
		'demo8' => 722,
		'demo9' => 733,
		'demo10' => 746,
		'demo11' => 757,
		'demo12' => 758,
	);

	$data = $collection->to_array();

	foreach( $data['tasks'] as $task ) {
		if( $task['id'] == 'demo:demo-download' ){
			$demo_id = $task['args']['demo_id'];
			$page_id = $demos[$demo_id];
			update_option( 'page_on_front', $page_id );
			flush_rewrite_rules();
			break;
		}
	}

	// Update contact form 7 email
	$cf7ids = array( 7, 391, 1011, 1050 );
	foreach ( $cf7ids as $cf7id ) {
		$mail = get_post_meta( $cf7id, '_mail', true );
		$mail['recipient'] = get_option( 'admin_email' );
		if ( class_exists( 'WPCF7_ContactFormTemplate' ) ) {
			$pattern = "/<[^@\s]*@[^@\s]*\.[^@\s]*>/"; // <email@email.com>
			$replacement = '<'. WPCF7_ContactFormTemplate::from_email().'>';
			$mail['sender'] = preg_replace($pattern, $replacement, $mail['sender']);
		}
		update_post_meta( $cf7id, '_mail', $mail );		
	}

	// Update WooCommerce emails
	$admin_email = get_option( 'admin_email' );
	update_option( 'woocommerce_email_from_address', $admin_email );
	update_option( 'woocommerce_stock_email_recipient', $admin_email );

	// Update post author id
	global $wpdb;
	$id = get_current_user_id();
	if ( $id != 1 ) {
		$query = "UPDATE $wpdb->posts SET post_author = $id";
		$wpdb->query($query);		
	}
}
